/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.axis.scalepolicy;

import info.monitorenter.gui.chart.IAxis;
import info.monitorenter.gui.chart.IAxisScalePolicy;
import info.monitorenter.gui.chart.LabeledValue;
import info.monitorenter.gui.chart.axis.AAxisTransformation;
import info.monitorenter.util.Range;
import java.awt.Graphics;
import java.util.LinkedList;
import java.util.List;

public class AxisScalePolicyTransformation
implements IAxisScalePolicy {
    @Override
    public List<LabeledValue> getScaleValues(Graphics g2d, IAxis<?> axis) {
        AAxisTransformation axisTransformation = (AAxisTransformation)axis;
        LinkedList<LabeledValue> collect = new LinkedList<LabeledValue>();
        Range domain = axis.getRange();
        double min = domain.getMin();
        double max = domain.getMax();
        min = axisTransformation.transform(min);
        max = axisTransformation.transform(max);
        double range = max - min;
        double exp = 0.0;
        double val = axisTransformation.untransform(0.0);
        while (val <= axis.getMax()) {
            if (val >= axis.getMin()) {
                LabeledValue label = new LabeledValue();
                label.setValue(val);
                label.setLabel(axis.getFormatter().format(label.getValue()));
                label.setMajorTick(true);
                label.setValue((axisTransformation.transform(label.getValue()) - min) / range);
                collect.add(label);
            }
            val = axisTransformation.untransform(exp += 1.0);
        }
        return collect;
    }

    @Override
    public void initPaintIteration(IAxis<?> axis) {
    }
}

