/*
 * Decompiled with CFR 0.152.
 */
package org.jdmp.gui.sample;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.table.AbstractTableModel;
import org.jdmp.core.dataset.ListDataSet;
import org.jdmp.core.sample.Sample;

public class SampleListTableModel
extends AbstractTableModel
implements ListDataListener {
    private static final long serialVersionUID = -5468178300746964431L;
    private Set<String> keys = new HashSet<String>();
    private Map<Integer, String> columnMap = new HashMap<Integer, String>();
    private ListDataSet iSamples = null;

    public SampleListTableModel(ListDataSet iSamples) {
        this.iSamples = iSamples;
    }

    @Override
    public int getRowCount() {
        return this.iSamples.size();
    }

    @Override
    public int getColumnCount() {
        return Math.max(1, this.keys.size());
    }

    @Override
    public String getColumnName(int columnIndex) {
        String s = this.columnMap.get(columnIndex);
        return s == null ? "unknown" : s;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return Sample.class;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Sample s = (Sample)this.iSamples.get(rowIndex);
        if (s == null) {
            return null;
        }
        for (String key : s.keySet()) {
            if (!this.keys.add(key)) continue;
            this.columnMap.put(this.columnMap.size(), key);
            this.fireTableStructureChanged();
        }
        return s;
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        if (e.getIndex0() < 0 || e.getIndex1() < 0) {
            this.fireTableDataChanged();
        } else {
            try {
                this.fireTableRowsUpdated(e.getIndex0(), e.getIndex1());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.fireTableDataChanged();
            }
        }
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        try {
            this.fireTableRowsInserted(e.getIndex0(), e.getIndex1());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.fireTableDataChanged();
        }
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        try {
            this.fireTableRowsDeleted(e.getIndex0(), e.getIndex1());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.fireTableDataChanged();
        }
    }

    public Set<String> getKeys() {
        return this.keys;
    }

    public Map<Integer, String> getColumnMap() {
        return this.columnMap;
    }
}

