/*
 * Decompiled with CFR 0.152.
 */
package org.jdmp.core.util;

import org.jdmp.core.variable.Variable;
import org.ujmp.core.Matrix;
import org.ujmp.core.objectmatrix.stub.AbstractDenseObjectMatrix2D;

public class MatrixListToMatrixWrapper
extends AbstractDenseObjectMatrix2D {
    private static final long serialVersionUID = 3023715319099124633L;
    private final Variable variable;

    public MatrixListToMatrixWrapper(Variable variable) {
        super(0L, 0L);
        this.variable = variable;
    }

    @Override
    public long[] getSize() {
        long cols = 0L;
        long rows = 0L;
        for (Matrix m : this.variable) {
            cols = Math.max(m.getColumnCount(), cols);
            rows += m.getRowCount();
        }
        return new long[]{rows, cols};
    }

    @Override
    public Object getObject(int row, int column) {
        return this.getObject((long)row, (long)column);
    }

    @Override
    public Object getObject(long row, long column) {
        long rows = 0L;
        for (Matrix m : this.variable) {
            if ((rows += m.getRowCount()) <= row) continue;
            long r = row - rows + m.getRowCount();
            if (column < m.getColumnCount()) {
                return m.getAsObject(r, column);
            }
            return 0.0;
        }
        return 0.0;
    }

    @Override
    public void setObject(Object value, int row, int column) {
        this.setObject(value, (long)row, (long)column);
    }

    @Override
    public void setObject(Object value, long row, long column) {
        long rows = 0L;
        for (Matrix m : this.variable) {
            if ((rows += m.getRowCount()) <= row) continue;
            long r = row - rows + m.getRowCount();
            if (column < m.getColumnCount()) {
                m.setAsObject(value, r, column);
                return;
            }
            return;
        }
    }
}

