/*
 * Decompiled with CFR 0.152.
 */
package org.jdmp.core.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jdmp.core.util.ObservableMap;
import org.ujmp.core.collections.list.FastArrayList;
import org.ujmp.core.interfaces.CoreObject;
import org.ujmp.core.interfaces.HasId;

public abstract class AbstractObservableMap<V extends CoreObject>
implements ObservableMap<V> {
    private static final long serialVersionUID = 1138872662801106054L;
    private EventListenerList listenerList = null;
    private final Map<String, V> map;
    private List<String> list = null;

    public AbstractObservableMap(Map<String, V> map) {
        this.map = map;
    }

    public AbstractObservableMap() {
        this.map = new TreeMap<String, V>();
    }

    public final Map<String, V> getMap() {
        return this.map;
    }

    public final List<String> getList() {
        if (this.list == null) {
            this.list = new FastArrayList<String>(this.getMap().size());
        }
        if (this.list.size() != this.getMap().size()) {
            this.list.clear();
            this.list.addAll(this.getMap().keySet());
        }
        return this.list;
    }

    @Override
    public final synchronized V getElementAt(int index) {
        return (V)this.get(this.getList().get(index));
    }

    @Override
    public final synchronized V get(Object key) {
        return (V)((CoreObject)this.getMap().get(key));
    }

    @Override
    public void addAll(Collection<? extends V> objects) {
        for (CoreObject v : objects) {
            this.add((V)v);
        }
    }

    @Override
    public void add(V object) {
        if (!(object instanceof HasId)) {
            throw new RuntimeException("object does not have an id");
        }
        this.put(object.getId(), object);
    }

    public final synchronized int indexOf(V value) {
        return this.getList().indexOf(value);
    }

    @Override
    public final synchronized int getSize() {
        return this.getMap().size();
    }

    @Override
    public final synchronized V put(String key, V value) {
        CoreObject v = (CoreObject)this.getMap().put(key, value);
        return (V)v;
    }

    @Override
    public final synchronized V remove(Object key) {
        int index = this.indexOf((CoreObject)this.getMap().get(key));
        CoreObject v = (CoreObject)this.getMap().remove(key);
        this.getList().clear();
        if (index >= 0) {
            this.fireIntervalRemoved(this, index, index);
        }
        return (V)v;
    }

    public final void fireContentsChanged() {
        this.fireContentsChanged(this, -1, -1);
    }

    @Override
    public synchronized Iterator<V> iterator() {
        return this.getMap().values().iterator();
    }

    @Override
    public final boolean isEmpty() {
        return this.getMap().isEmpty();
    }

    @Override
    public final void clear() {
        int size = this.getMap().size();
        this.getMap().clear();
        this.getList().clear();
        this.fireIntervalRemoved(this, 0, size - 1);
    }

    public final Collection<V> toCollection() {
        return this.getMap().values();
    }

    @Override
    public final Set<String> keySet() {
        return this.getMap().keySet();
    }

    @Override
    public final boolean containsKey(Object key) {
        return this.getMap().containsKey(key);
    }

    @Override
    public final boolean containsValue(Object value) {
        return this.getMap().containsValue(value);
    }

    @Override
    public final Set<Map.Entry<String, V>> entrySet() {
        return this.getMap().entrySet();
    }

    @Override
    public final void putAll(Map<? extends String, ? extends V> m) {
        for (String string : m.keySet()) {
            CoreObject v = (CoreObject)m.get(string);
            this.put(string, (V)v);
        }
    }

    @Override
    public final int size() {
        return this.getMap().size();
    }

    @Override
    public final Collection<V> values() {
        return this.getMap().values();
    }

    public final String toString() {
        return this.getMap().toString();
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(ListDataListener.class, l);
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        if (this.listenerList == null) {
            return;
        }
        this.listenerList.remove(ListDataListener.class, l);
    }

    protected void fireContentsChanged(Object source, int index0, int index1) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        ListDataEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ListDataListener.class) continue;
            if (e == null) {
                e = new ListDataEvent(source, 0, index0, index1);
            }
            ((ListDataListener)listeners[i + 1]).contentsChanged(e);
        }
    }

    protected void fireIntervalAdded(Object source, int index0, int index1) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        ListDataEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ListDataListener.class) continue;
            if (e == null) {
                e = new ListDataEvent(source, 1, index0, index1);
            }
            ((ListDataListener)listeners[i + 1]).intervalAdded(e);
        }
    }

    protected void fireIntervalRemoved(Object source, int index0, int index1) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        ListDataEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ListDataListener.class) continue;
            if (e == null) {
                e = new ListDataEvent(source, 2, index0, index1);
            }
            ((ListDataListener)listeners[i + 1]).intervalRemoved(e);
        }
    }
}

