/*
 * Decompiled with CFR 0.152.
 */
package org.jdmp.core.script.jdmp;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jdmp.core.algorithm.Algorithm;
import org.jdmp.core.algorithm.AlgorithmMapping;
import org.jdmp.core.dataset.DataSetFactory;
import org.jdmp.core.dataset.ListDataSet;
import org.jdmp.core.module.Module;
import org.jdmp.core.module.ModuleFactory;
import org.jdmp.core.sample.SampleFactory;
import org.jdmp.core.script.Result;
import org.jdmp.core.script.jdmp.analysis.DepthFirstAdapter;
import org.jdmp.core.script.jdmp.node.AAndLevel7;
import org.jdmp.core.script.jdmp.node.AArgumentListArgumentList;
import org.jdmp.core.script.jdmp.node.AArray;
import org.jdmp.core.script.jdmp.node.AArrayAssignment;
import org.jdmp.core.script.jdmp.node.AArrayMatrix;
import org.jdmp.core.script.jdmp.node.ABitComplementLevel2;
import org.jdmp.core.script.jdmp.node.ABooleanLiteral;
import org.jdmp.core.script.jdmp.node.AColumn;
import org.jdmp.core.script.jdmp.node.AColumnMatrix;
import org.jdmp.core.script.jdmp.node.ACommaValue;
import org.jdmp.core.script.jdmp.node.AComplementLevel2;
import org.jdmp.core.script.jdmp.node.ADotLdivLevel3;
import org.jdmp.core.script.jdmp.node.ADotMultLevel3;
import org.jdmp.core.script.jdmp.node.ADotPowerLevel1;
import org.jdmp.core.script.jdmp.node.ADotRdivLevel3;
import org.jdmp.core.script.jdmp.node.ADotTransposeLevel1;
import org.jdmp.core.script.jdmp.node.AEmptyFunction;
import org.jdmp.core.script.jdmp.node.AEmptyMatrix;
import org.jdmp.core.script.jdmp.node.AEqLevel6;
import org.jdmp.core.script.jdmp.node.AExpressionArgumentList;
import org.jdmp.core.script.jdmp.node.AExpressionLevel0;
import org.jdmp.core.script.jdmp.node.AFloatingPointLiteral;
import org.jdmp.core.script.jdmp.node.AFunctionLevel0;
import org.jdmp.core.script.jdmp.node.AGtLevel6;
import org.jdmp.core.script.jdmp.node.AGteqLevel6;
import org.jdmp.core.script.jdmp.node.AIdentifierAssignment;
import org.jdmp.core.script.jdmp.node.AIdentifierLevel0;
import org.jdmp.core.script.jdmp.node.AIntegerLiteral;
import org.jdmp.core.script.jdmp.node.ALdivLevel3;
import org.jdmp.core.script.jdmp.node.ALevel0Level1;
import org.jdmp.core.script.jdmp.node.ALevel10Expression;
import org.jdmp.core.script.jdmp.node.ALevel1Level2;
import org.jdmp.core.script.jdmp.node.ALevel2Level3;
import org.jdmp.core.script.jdmp.node.ALevel3Level4;
import org.jdmp.core.script.jdmp.node.ALevel4Level5;
import org.jdmp.core.script.jdmp.node.ALevel5Level6;
import org.jdmp.core.script.jdmp.node.ALevel6Level7;
import org.jdmp.core.script.jdmp.node.ALevel7Level8;
import org.jdmp.core.script.jdmp.node.ALevel8Level9;
import org.jdmp.core.script.jdmp.node.ALevel9Level10;
import org.jdmp.core.script.jdmp.node.ALiteralLevel0;
import org.jdmp.core.script.jdmp.node.ALogicalAndLevel9;
import org.jdmp.core.script.jdmp.node.ALogicalOrLevel10;
import org.jdmp.core.script.jdmp.node.ALtLevel6;
import org.jdmp.core.script.jdmp.node.ALteqLevel6;
import org.jdmp.core.script.jdmp.node.AMatrixLevel0;
import org.jdmp.core.script.jdmp.node.AMinusLevel2;
import org.jdmp.core.script.jdmp.node.AMinusLevel4;
import org.jdmp.core.script.jdmp.node.AMultLevel3;
import org.jdmp.core.script.jdmp.node.ANeqLevel6;
import org.jdmp.core.script.jdmp.node.AOrLevel8;
import org.jdmp.core.script.jdmp.node.AParameterFunction;
import org.jdmp.core.script.jdmp.node.APlusLevel2;
import org.jdmp.core.script.jdmp.node.APlusLevel4;
import org.jdmp.core.script.jdmp.node.APowerLevel1;
import org.jdmp.core.script.jdmp.node.AQualifiedName;
import org.jdmp.core.script.jdmp.node.ARangeLevel5;
import org.jdmp.core.script.jdmp.node.ARdivLevel3;
import org.jdmp.core.script.jdmp.node.ARow;
import org.jdmp.core.script.jdmp.node.ARowMatrix;
import org.jdmp.core.script.jdmp.node.ASemicolonRow;
import org.jdmp.core.script.jdmp.node.ASemicolonValue;
import org.jdmp.core.script.jdmp.node.ASimpleName;
import org.jdmp.core.script.jdmp.node.AStatement;
import org.jdmp.core.script.jdmp.node.AStringLiteral;
import org.jdmp.core.script.jdmp.node.ATransposeLevel1;
import org.jdmp.core.script.jdmp.node.AValueMatrix;
import org.jdmp.core.script.jdmp.node.Node;
import org.jdmp.core.script.jdmp.node.PArgumentList;
import org.jdmp.core.script.jdmp.node.PArray;
import org.jdmp.core.script.jdmp.node.PColumn;
import org.jdmp.core.script.jdmp.node.PCommaValue;
import org.jdmp.core.script.jdmp.node.PExpression;
import org.jdmp.core.script.jdmp.node.PFunction;
import org.jdmp.core.script.jdmp.node.PLevel0;
import org.jdmp.core.script.jdmp.node.PLevel1;
import org.jdmp.core.script.jdmp.node.PLevel10;
import org.jdmp.core.script.jdmp.node.PLevel2;
import org.jdmp.core.script.jdmp.node.PLevel3;
import org.jdmp.core.script.jdmp.node.PLevel4;
import org.jdmp.core.script.jdmp.node.PLevel5;
import org.jdmp.core.script.jdmp.node.PLevel6;
import org.jdmp.core.script.jdmp.node.PLevel7;
import org.jdmp.core.script.jdmp.node.PLevel8;
import org.jdmp.core.script.jdmp.node.PLevel9;
import org.jdmp.core.script.jdmp.node.PLiteral;
import org.jdmp.core.script.jdmp.node.PMatrix;
import org.jdmp.core.script.jdmp.node.PName;
import org.jdmp.core.script.jdmp.node.PRow;
import org.jdmp.core.script.jdmp.node.PSemicolonRow;
import org.jdmp.core.script.jdmp.node.PSemicolonValue;
import org.jdmp.core.variable.Variable;
import org.jdmp.core.variable.VariableFactory;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.core.objectmatrix.DenseObjectMatrix2D;
import org.ujmp.core.util.MathUtil;
import org.ujmp.core.util.StringUtil;

public class Translation
extends DepthFirstAdapter {
    public static final String ANS = "ans";
    private Module module = null;
    private Result result = null;
    private final boolean ignoreNaN = true;

    public Translation(Module module) {
        this.module = module;
    }

    private Variable getVariable(PName identifier) {
        String label = identifier.toString().trim();
        Variable v = (Variable)this.module.getVariableMap().get(label);
        if (v == null) {
            v = Variable.Factory.labeledVariable(label);
            this.module.getVariableMap().put(label, v);
        }
        return v;
    }

    private Matrix getMatrix(PArray array) throws Exception {
        AArray aArray = (AArray)array;
        ARow aRow = (ARow)aArray.getRow();
        int rows = aArray.getAdditionalRows().size() + 1;
        int columns = aRow.getAdditionalValues().size() + 1;
        for (PSemicolonRow semicolonRow : aArray.getAdditionalRows()) {
            aRow = (ARow)((ASemicolonRow)semicolonRow).getRow();
            columns = Math.max(columns, aRow.getAdditionalValues().size() + 1);
        }
        Object m = DenseObjectMatrix2D.Factory.zeros((long)rows, (long)columns);
        aRow = (ARow)aArray.getRow();
        PExpression expr = aRow.getExpression();
        m.setAsObject(this.getSingleValue(expr), 0L, 0L);
        int c = 1;
        for (PCommaValue commaValue : aRow.getAdditionalValues()) {
            ACommaValue aCommaValue = (ACommaValue)commaValue;
            expr = aCommaValue.getExpression();
            m.setAsObject(this.getSingleValue(expr), 0L, c++);
        }
        int r = 1;
        for (PSemicolonRow semicolonRow : aArray.getAdditionalRows()) {
            aRow = (ARow)((ASemicolonRow)semicolonRow).getRow();
            expr = aRow.getExpression();
            m.setAsObject(this.getSingleValue(expr), r, 0L);
            c = 1;
            for (PCommaValue commaValue : aRow.getAdditionalValues()) {
                ACommaValue aCommaValue = (ACommaValue)commaValue;
                expr = aCommaValue.getExpression();
                m.setAsObject(this.getSingleValue(expr), r, c++);
            }
            ++r;
        }
        return m;
    }

    private Matrix getMatrix(PRow row) throws Exception {
        ARow aRow = (ARow)row;
        int columns = aRow.getAdditionalValues().size() + 1;
        Object m = DenseObjectMatrix2D.Factory.zeros(1L, (long)columns);
        m.setAsObject(this.getSingleValue(aRow.getExpression()), 0L, 0L);
        int i = 1;
        for (PCommaValue commaValue : aRow.getAdditionalValues()) {
            PExpression expr = ((ACommaValue)commaValue).getExpression();
            m.setAsObject(this.getSingleValue(expr), 0L, i++);
        }
        return m;
    }

    private Matrix getMatrix(PColumn column) throws Exception {
        AColumn aColumn = (AColumn)column;
        int rows = aColumn.getAdditionalValues().size() + 1;
        Object m = DenseObjectMatrix2D.Factory.zeros((long)rows, 1L);
        m.setAsObject(this.getSingleValue(aColumn.getExpression()), 0L, 0L);
        int i = 1;
        for (PSemicolonValue semicolonValue : aColumn.getAdditionalValues()) {
            PExpression expr = ((ASemicolonValue)semicolonValue).getExpression();
            m.setAsObject(this.getSingleValue(expr), i++, 0L);
        }
        return m;
    }

    @Override
    public void defaultOut(Node node) {
        System.out.println(node.getClass().getSimpleName() + ": " + node);
    }

    public Result getResult() {
        return this.result;
    }

    @Override
    public void outAArrayAssignment(AArrayAssignment node) {
        RuntimeException e = new RuntimeException("array assignments are not supported yet.");
        this.result = new Result(e);
        e.printStackTrace();
    }

    @Override
    public void outAIdentifierAssignment(AIdentifierAssignment node) {
        try {
            String id = node.getName().toString().trim();
            Object o = this.getObject(node.getExpression());
            if (o instanceof Module) {
                Module m = (Module)o;
                if (!ANS.equals(id)) {
                    this.module.getModuleMap().put(id, m);
                }
                this.result = new Result(id, m);
            } else if (o instanceof ListDataSet) {
                ListDataSet ds = (ListDataSet)o;
                if (!ANS.equals(id)) {
                    this.module.getDataSetMap().put(id, ds);
                }
                this.result = new Result(id, ds);
            } else if (o instanceof Variable) {
                Variable v = (Variable)o;
                if (!ANS.equals(id)) {
                    this.module.getVariableMap().put(id, v);
                }
                this.result = new Result(id, v);
            } else if (o instanceof Algorithm) {
                Algorithm a = (Algorithm)o;
                if (!ANS.equals(id)) {
                    this.module.getAlgorithmMap().put(id, a);
                }
                this.result = new Result(id, a);
            } else {
                Matrix m = MathUtil.getMatrix(o);
                if (m != null) {
                    Variable v = this.getVariable(node.getName());
                    v.add(m);
                    this.result = new Result(v.getLabel(), m);
                    System.out.println(this.result.toString());
                }
            }
        }
        catch (Exception e) {
            this.result = new Result(e);
            e.printStackTrace();
        }
    }

    private Object getObject(PExpression expression) throws Exception {
        if (expression instanceof ALevel10Expression) {
            return this.getObject(((ALevel10Expression)expression).getLevel10());
        }
        RuntimeException e = new RuntimeException("Unknown expression type: " + expression.getClass().getSimpleName());
        this.result = new Result(e);
        throw e;
    }

    private Object getObject(PLevel10 expression) throws Exception {
        if (expression instanceof ALevel9Level10) {
            return this.getObject(((ALevel9Level10)expression).getLevel9());
        }
        if (expression instanceof ALogicalOrLevel10) {
            ALogicalOrLevel10 exp = (ALogicalOrLevel10)expression;
            Matrix left = MathUtil.getMatrix(this.getObject(exp.getLeft()));
            Matrix right = MathUtil.getMatrix(this.getObject(exp.getRight()));
            return left.or(Calculation.Ret.NEW, right);
        }
        RuntimeException e = new RuntimeException("Unknown expression type: " + expression.getClass().getSimpleName());
        this.result = new Result(e);
        throw e;
    }

    private Object getObject(PLevel9 expression) throws Exception {
        if (expression instanceof ALevel8Level9) {
            return this.getObject(((ALevel8Level9)expression).getLevel8());
        }
        if (expression instanceof ALogicalAndLevel9) {
            ALogicalAndLevel9 exp = (ALogicalAndLevel9)expression;
            Matrix left = MathUtil.getMatrix(this.getObject(exp.getLeft()));
            Matrix right = MathUtil.getMatrix(this.getObject(exp.getRight()));
            return left.and(Calculation.Ret.NEW, right);
        }
        RuntimeException e = new RuntimeException("Unknown expression type: " + expression.getClass().getSimpleName());
        this.result = new Result(e);
        throw e;
    }

    private Object getObject(PLevel8 expression) throws Exception {
        if (expression instanceof ALevel7Level8) {
            return this.getObject(((ALevel7Level8)expression).getLevel7());
        }
        if (expression instanceof AOrLevel8) {
            // empty if block
        }
        RuntimeException e = new RuntimeException("Unknown expression type: " + expression.getClass().getSimpleName());
        this.result = new Result(e);
        throw e;
    }

    private Object getObject(PLevel7 expression) throws Exception {
        if (expression instanceof ALevel6Level7) {
            return this.getObject(((ALevel6Level7)expression).getLevel6());
        }
        if (expression instanceof AAndLevel7) {
            // empty if block
        }
        RuntimeException e = new RuntimeException("Unknown expression type: " + expression.getClass().getSimpleName());
        this.result = new Result(e);
        throw e;
    }

    private Object getObject(PLevel6 expression) throws Exception {
        if (expression instanceof ALevel5Level6) {
            return this.getObject(((ALevel5Level6)expression).getLevel5());
        }
        if (expression instanceof AEqLevel6) {
            AEqLevel6 exp = (AEqLevel6)expression;
            Matrix left = MathUtil.getMatrix(this.getObject(exp.getLeft()));
            Matrix right = MathUtil.getMatrix(this.getObject(exp.getRight()));
            return left.eq(Calculation.Ret.NEW, right);
        }
        if (expression instanceof ANeqLevel6) {
            ANeqLevel6 exp = (ANeqLevel6)expression;
            Matrix left = MathUtil.getMatrix(this.getObject(exp.getLeft()));
            Matrix right = MathUtil.getMatrix(this.getObject(exp.getRight()));
            return left.ne(Calculation.Ret.NEW, right);
        }
        if (expression instanceof AGtLevel6) {
            AGtLevel6 exp = (AGtLevel6)expression;
            Matrix left = MathUtil.getMatrix(this.getObject(exp.getLeft()));
            Matrix right = MathUtil.getMatrix(this.getObject(exp.getRight()));
            return left.gt(Calculation.Ret.NEW, right);
        }
        if (expression instanceof ALtLevel6) {
            ALtLevel6 exp = (ALtLevel6)expression;
            Matrix left = MathUtil.getMatrix(this.getObject(exp.getLeft()));
            Matrix right = MathUtil.getMatrix(this.getObject(exp.getRight()));
            return left.lt(Calculation.Ret.NEW, right);
        }
        if (expression instanceof AGteqLevel6) {
            AGteqLevel6 exp = (AGteqLevel6)expression;
            Matrix left = MathUtil.getMatrix(this.getObject(exp.getLeft()));
            Matrix right = MathUtil.getMatrix(this.getObject(exp.getRight()));
            return left.ge(Calculation.Ret.NEW, right);
        }
        if (expression instanceof ALteqLevel6) {
            ALteqLevel6 exp = (ALteqLevel6)expression;
            Matrix left = MathUtil.getMatrix(this.getObject(exp.getLeft()));
            Matrix right = MathUtil.getMatrix(this.getObject(exp.getRight()));
            return left.le(Calculation.Ret.NEW, right);
        }
        RuntimeException e = new RuntimeException("Unknown expression type: " + expression.getClass().getSimpleName());
        this.result = new Result(e);
        throw e;
    }

    private Object getObject(PLevel5 expression) throws Exception {
        if (expression instanceof ALevel4Level5) {
            return this.getObject(((ALevel4Level5)expression).getLevel4());
        }
        if (expression instanceof ARangeLevel5) {
            // empty if block
        }
        RuntimeException e = new RuntimeException("Unknown expression type: " + expression.getClass().getSimpleName());
        this.result = new Result(e);
        throw e;
    }

    private Object getObject(PLevel4 calculation) throws Exception {
        if (calculation instanceof ALevel3Level4) {
            return this.getObject(((ALevel3Level4)calculation).getLevel3());
        }
        if (calculation instanceof APlusLevel4) {
            APlusLevel4 op = (APlusLevel4)calculation;
            PLevel4 left = op.getLeft();
            PLevel3 right = op.getRight();
            Matrix leftM = MathUtil.getMatrix(this.getObject(left));
            Matrix rightM = MathUtil.getMatrix(this.getObject(right));
            return leftM.plus(Calculation.Ret.NEW, true, rightM);
        }
        if (calculation instanceof AMinusLevel4) {
            AMinusLevel4 op = (AMinusLevel4)calculation;
            PLevel4 left = op.getLeft();
            PLevel3 right = op.getRight();
            Matrix leftM = MathUtil.getMatrix(this.getObject(left));
            Matrix rightM = MathUtil.getMatrix(this.getObject(right));
            return leftM.minus(Calculation.Ret.NEW, true, rightM);
        }
        RuntimeException e = new RuntimeException("Unknown expression type: " + calculation.getClass().getSimpleName());
        this.result = new Result(e);
        throw e;
    }

    private Object getObject(PLevel3 term) throws Exception {
        Matrix left;
        if (term instanceof ALevel2Level3) {
            return this.getObject(((ALevel2Level3)term).getLevel2());
        }
        if (term instanceof AMultLevel3) {
            Matrix left2 = MathUtil.getMatrix(this.getObject(((AMultLevel3)term).getLeft()));
            Matrix right = MathUtil.getMatrix(this.getObject(((AMultLevel3)term).getRight()));
            return left2.mtimes(Calculation.Ret.NEW, true, right);
        }
        if (term instanceof ADotMultLevel3) {
            Matrix left3 = MathUtil.getMatrix(this.getObject(((ADotMultLevel3)term).getLeft()));
            Matrix right = MathUtil.getMatrix(this.getObject(((ADotMultLevel3)term).getRight()));
            return left3.times(Calculation.Ret.NEW, true, right);
        }
        if (term instanceof ARdivLevel3) {
            Matrix left4 = MathUtil.getMatrix(this.getObject(((ARdivLevel3)term).getLeft()));
            Matrix right = MathUtil.getMatrix(this.getObject(((ARdivLevel3)term).getRight()));
            return left4.divide(Calculation.Ret.NEW, true, right);
        }
        if (term instanceof ADotRdivLevel3) {
            Matrix left5 = MathUtil.getMatrix(this.getObject(((ADotRdivLevel3)term).getLeft()));
            Matrix right = MathUtil.getMatrix(this.getObject(((ADotRdivLevel3)term).getRight()));
            return left5.divide(Calculation.Ret.NEW, true, right);
        }
        if (term instanceof ALdivLevel3) {
            left = MathUtil.getMatrix(this.getObject(((ALdivLevel3)term).getLeft()));
            Matrix matrix = MathUtil.getMatrix(this.getObject(((ALdivLevel3)term).getRight()));
        } else if (term instanceof ADotLdivLevel3) {
            left = MathUtil.getMatrix(this.getObject(((ADotLdivLevel3)term).getLeft()));
            Matrix matrix = MathUtil.getMatrix(this.getObject(((ADotLdivLevel3)term).getRight()));
        }
        RuntimeException e = new RuntimeException("Unknown expression type: " + term.getClass().getSimpleName());
        this.result = new Result(e);
        throw e;
    }

    private Object getObject(PLevel0 factor) throws Exception {
        if (factor instanceof ALiteralLevel0) {
            return Matrix.Factory.linkToValue(this.getValue(((ALiteralLevel0)factor).getLiteral()));
        }
        if (factor instanceof AMatrixLevel0) {
            return this.getMatrix(((AMatrixLevel0)factor).getMatrix());
        }
        if (factor instanceof AExpressionLevel0) {
            return this.getObject(((AExpressionLevel0)factor).getExpression());
        }
        if (factor instanceof AFunctionLevel0) {
            return this.getObject(((AFunctionLevel0)factor).getFunction());
        }
        if (factor instanceof AIdentifierLevel0) {
            Variable v;
            String name = ((AIdentifierLevel0)factor).getName().toString().trim();
            if (ANS.equals(name) && this.module.getVariableMap().get(ANS) == null) {
                this.module.getVariableMap().put(ANS, Variable.Factory.labeledVariable(ANS));
            }
            if ((v = (Variable)this.module.getVariableMap().get(name)) != null) {
                return v.getLast();
            }
            ListDataSet ds = (ListDataSet)this.module.getDataSetMap().get(name);
            if (ds != null) {
                return ds;
            }
            Module m = (Module)this.module.getModuleMap().get(name);
            if (m != null) {
                return m;
            }
            Algorithm a = (Algorithm)this.module.getAlgorithmMap().get(name);
            if (a != null) {
                return a;
            }
            a = this.getAlgorithm(name);
            if (a != null) {
                return this.executeAlgorithm(a, null);
            }
            RuntimeException e = new RuntimeException("Unknown object or command: " + name);
            this.result = new Result(e);
            throw e;
        }
        RuntimeException e = new RuntimeException("Unknown expression type: " + factor.getClass().getSimpleName());
        this.result = new Result(e);
        throw e;
    }

    private Object getObject(PLevel2 factor) throws Exception {
        if (factor instanceof ALevel1Level2) {
            return this.getObject(((ALevel1Level2)factor).getLevel1());
        }
        if (factor instanceof AMinusLevel2) {
            Matrix m = MathUtil.getMatrix(this.getObject(((AMinusLevel2)factor).getLevel1()));
            return m.times(-1.0);
        }
        if (factor instanceof APlusLevel2) {
            return this.getObject(((APlusLevel2)factor).getLevel1());
        }
        if (factor instanceof AComplementLevel2) {
            Matrix m = MathUtil.getMatrix(this.getObject(((AComplementLevel2)factor).getLevel1()));
            return m.not(Calculation.Ret.NEW);
        }
        if (factor instanceof ABitComplementLevel2) {
            // empty if block
        }
        RuntimeException e = new RuntimeException("Unknown expression type: " + factor.getClass().getSimpleName());
        this.result = new Result(e);
        throw e;
    }

    private Object getObject(PLevel1 factor) throws Exception {
        if (factor instanceof ALevel0Level1) {
            return this.getObject(((ALevel0Level1)factor).getLevel0());
        }
        if (factor instanceof APowerLevel1) {
            Matrix left = MathUtil.getMatrix(this.getObject(((APowerLevel1)factor).getLeft()));
            Matrix matrix = MathUtil.getMatrix(this.getObject(((APowerLevel1)factor).getRight()));
        } else {
            if (factor instanceof ADotPowerLevel1) {
                Matrix left = MathUtil.getMatrix(this.getObject(((ADotPowerLevel1)factor).getLeft()));
                Matrix right = MathUtil.getMatrix(this.getObject(((ADotPowerLevel1)factor).getRight()));
                return left.power(Calculation.Ret.NEW, right);
            }
            if (factor instanceof ATransposeLevel1) {
                Matrix m = MathUtil.getMatrix(this.getObject(((ATransposeLevel1)factor).getLevel0()));
                return m.transpose();
            }
            if (factor instanceof ADotTransposeLevel1) {
                Matrix m = MathUtil.getMatrix(this.getObject(((ADotTransposeLevel1)factor).getLevel0()));
                return m.transpose();
            }
        }
        RuntimeException e = new RuntimeException("Unknown expression type: " + factor.getClass().getSimpleName());
        this.result = new Result(e);
        throw e;
    }

    public Object executeFunction(PName name, PArgumentList arguments) throws Exception {
        if (name instanceof ASimpleName) {
            ASimpleName sn = (ASimpleName)name;
            String id = sn.getIdentifier().toString().trim();
            Algorithm algorithm = this.getAlgorithm(id);
            if (algorithm == null) {
                RuntimeException e = new RuntimeException("Unknown algorithm: " + id);
                this.result = new Result(e);
                throw e;
            }
            return this.executeAlgorithm(algorithm, arguments);
        }
        if (name instanceof AQualifiedName) {
            AQualifiedName qn = (AQualifiedName)name;
            String id = qn.getName().toString().trim();
            Object object = this.getObject(id);
            if (object == null) {
                String methodName = qn.getIdentifier().toString().trim();
                Class c = null;
                if ("VariableFactory".equals(id)) {
                    c = VariableFactory.class;
                } else if ("SampleFactory".equals(id)) {
                    c = SampleFactory.class;
                } else if ("ModuleFactory".equals(id)) {
                    c = ModuleFactory.class;
                } else if ("DataSetFactory".equals(id)) {
                    c = DataSetFactory.class;
                }
                if (c != null) {
                    return this.executeMethod(c, null, methodName, arguments);
                }
                RuntimeException e = new RuntimeException("Unknown identifier: " + id);
                this.result = new Result(e);
                throw e;
            }
            return this.executeMethod(object.getClass(), object, qn.getIdentifier().toString().trim(), arguments);
        }
        RuntimeException e = new RuntimeException("Unknown function: " + name.getClass().getSimpleName());
        this.result = new Result(e);
        throw e;
    }

    private List<Object> getArgumentsAsObjects(PArgumentList arguments) throws Exception {
        ArrayList<Object> obj = new ArrayList<Object>();
        if (arguments == null) {
            return obj;
        }
        if (arguments instanceof AExpressionArgumentList) {
            PExpression expr = ((AExpressionArgumentList)arguments).getExpression();
            obj.add(this.getObject(expr));
            return obj;
        }
        if (arguments instanceof AArgumentListArgumentList) {
            PExpression expr = ((AArgumentListArgumentList)arguments).getExpression();
            obj.addAll(this.getArgumentsAsObjects(((AArgumentListArgumentList)arguments).getArgumentList()));
            obj.add(this.getObject(expr));
            return obj;
        }
        RuntimeException e = new RuntimeException("Unknown arguments: " + arguments.getClass().getSimpleName());
        this.result = new Result(e);
        throw e;
    }

    private Object executeAlgorithm(Algorithm algorithm, PArgumentList arguments) throws Exception {
        List<Object> matrices = this.getArgumentsAsObjects(arguments);
        Map<String, Object> ret = algorithm.calculateObjects(matrices);
        if (ret.isEmpty()) {
            return null;
        }
        return ret.values().iterator().next();
    }

    private Algorithm getAlgorithm(String id) throws Exception {
        Class<?> c = null;
        String cname = AlgorithmMapping.get(id);
        if (cname != null) {
            try {
                c = Class.forName(cname);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (c == null) {
            return null;
        }
        Constructor<?> constr = c.getConstructor(Variable.VARIABLEARRAY);
        Algorithm algorithm = (Algorithm)constr.newInstance(new Object[]{new Variable[0]});
        return algorithm;
    }

    private Object executeMethod(Class<?> c, Object object, String name, PArgumentList argumentList) throws Exception {
        List<Object> matrices = this.getArgumentsAsObjects(argumentList);
        for (Method method : c.getMethods()) {
            if (!method.getName().equals(name) || method.getParameterTypes().length != matrices.size()) continue;
            Object[] arguments = this.convertObjects(matrices, method.getParameterTypes());
            Object o = method.invoke(object, arguments);
            return o;
        }
        RuntimeException e = new RuntimeException("Unknown method: " + name);
        this.result = new Result(e);
        throw e;
    }

    private Object[] convertObjects(List<Object> matrices, Class<?>[] classes) {
        ArrayList<Object> objects = new ArrayList<Object>();
        for (int i = 0; i < classes.length; ++i) {
            Class<?> c = classes[i];
            Object m = matrices.get(i);
            Object o = this.convertObject(m, c);
            objects.add(o);
        }
        return objects.toArray();
    }

    private Object convertObject(Object m, Class<?> c) {
        if (c == Matrix.class) {
            return MathUtil.getMatrix(m);
        }
        if (c == Object.class) {
            return m;
        }
        if (c == Integer.TYPE) {
            return MathUtil.getInt(m);
        }
        if (c == Double.TYPE) {
            return MathUtil.getDouble(m);
        }
        if (c == Long.TYPE) {
            return MathUtil.getLong(m);
        }
        if (c == Boolean.TYPE) {
            return MathUtil.getBoolean(m);
        }
        if (c == String.class) {
            return StringUtil.convert(m);
        }
        if (c == ListDataSet.class) {
            return m;
        }
        RuntimeException e = new RuntimeException("cannot convert to desired object type " + c.getSimpleName());
        this.result = new Result(e);
        throw e;
    }

    private Object getObject(String name) {
        Object o = this.module.getVariableMap().get(name);
        if (o != null) {
            return ((Variable)o).getLast();
        }
        o = this.module.getDataSetMap().get(name);
        if (o != null) {
            return o;
        }
        o = this.module.getAlgorithmMap().get(name);
        if (o != null) {
            return o;
        }
        o = this.module.getModuleMap().get(name);
        if (o != null) {
            return o;
        }
        return o;
    }

    private Object getObject(PFunction function) throws Exception {
        if (function instanceof AParameterFunction) {
            return this.executeFunction(((AParameterFunction)function).getName(), ((AParameterFunction)function).getArgumentList());
        }
        if (function instanceof AEmptyFunction) {
            return this.executeFunction(((AEmptyFunction)function).getName(), null);
        }
        RuntimeException e = new RuntimeException("Unknown function type: " + function.getClass().getSimpleName());
        this.result = new Result(e);
        throw e;
    }

    private Matrix getMatrix(PMatrix matrix) throws Exception {
        if (matrix instanceof AEmptyMatrix) {
            return Matrix.Factory.emptyMatrix();
        }
        if (matrix instanceof AValueMatrix) {
            return Matrix.Factory.linkToValue(((AValueMatrix)matrix).getExpression());
        }
        if (matrix instanceof ARowMatrix) {
            return this.getMatrix(((ARowMatrix)matrix).getRow());
        }
        if (matrix instanceof AColumnMatrix) {
            return this.getMatrix(((AColumnMatrix)matrix).getColumn());
        }
        if (matrix instanceof AArrayMatrix) {
            return this.getMatrix(((AArrayMatrix)matrix).getArray());
        }
        RuntimeException e = new RuntimeException("Unknown matrix type: " + matrix.getClass().getSimpleName());
        this.result = new Result(e);
        throw e;
    }

    private Object getSingleValue(PExpression expression) throws Exception {
        Matrix m = MathUtil.getMatrix(this.getObject(expression));
        if (m.isScalar()) {
            return m.getAsObject(0L, 0L);
        }
        return m.doubleValue();
    }

    private Object getValue(PLiteral literal) {
        if (literal instanceof AIntegerLiteral) {
            return Long.parseLong(literal.toString().trim());
        }
        if (literal instanceof AFloatingPointLiteral) {
            String s = literal.toString().trim();
            if ("NaN".equalsIgnoreCase(s)) {
                return Double.NaN;
            }
            if ("Inf".equalsIgnoreCase(s)) {
                return Double.POSITIVE_INFINITY;
            }
            if ("-Inf".equalsIgnoreCase(s)) {
                return Double.NEGATIVE_INFINITY;
            }
            return Double.parseDouble(s);
        }
        if (literal instanceof ABooleanLiteral) {
            return Boolean.parseBoolean(literal.toString().trim());
        }
        if (literal instanceof AStringLiteral) {
            String s = literal.toString().trim();
            return s.substring(1, s.length() - 1);
        }
        RuntimeException e = new RuntimeException("Unknown literal type: " + literal.getClass().getSimpleName());
        this.result = new Result(e);
        throw e;
    }

    private String getLiteral(PExpression expr) {
        if (expr instanceof ALevel10Expression) {
            return this.getLiteral(((ALevel10Expression)expr).getLevel10());
        }
        return null;
    }

    private String getLiteral(PLevel10 expr) {
        if (expr instanceof ALevel9Level10) {
            return this.getLiteral(((ALevel9Level10)expr).getLevel9());
        }
        return null;
    }

    private String getLiteral(PLevel9 expr) {
        if (expr instanceof ALevel8Level9) {
            return this.getLiteral(((ALevel8Level9)expr).getLevel8());
        }
        return null;
    }

    private String getLiteral(PLevel8 expr) {
        if (expr instanceof ALevel7Level8) {
            return this.getLiteral(((ALevel7Level8)expr).getLevel7());
        }
        return null;
    }

    private String getLiteral(PLevel7 expr) {
        if (expr instanceof ALevel6Level7) {
            return this.getLiteral(((ALevel6Level7)expr).getLevel6());
        }
        return null;
    }

    private String getLiteral(PLevel6 expr) {
        if (expr instanceof ALevel5Level6) {
            return this.getLiteral(((ALevel5Level6)expr).getLevel5());
        }
        return null;
    }

    private String getLiteral(PLevel5 expr) {
        if (expr instanceof ALevel4Level5) {
            return this.getLiteral(((ALevel4Level5)expr).getLevel4());
        }
        return null;
    }

    private String getLiteral(PLevel4 expr) {
        if (expr instanceof ALevel3Level4) {
            return this.getLiteral(((ALevel3Level4)expr).getLevel3());
        }
        return null;
    }

    private String getLiteral(PLevel3 expr) {
        if (expr instanceof ALevel2Level3) {
            return this.getLiteral(((ALevel2Level3)expr).getLevel2());
        }
        return null;
    }

    private String getLiteral(PLevel2 expr) {
        if (expr instanceof ALevel1Level2) {
            return this.getLiteral(((ALevel1Level2)expr).getLevel1());
        }
        return null;
    }

    private String getLiteral(PLevel1 expr) {
        if (expr instanceof ALevel0Level1) {
            return this.getLiteral(((ALevel0Level1)expr).getLevel0());
        }
        return null;
    }

    private String getLiteral(PLevel0 expr) {
        if (expr instanceof ALiteralLevel0) {
            String s = expr.toString().trim();
            if ("true".equalsIgnoreCase(s)) {
                return null;
            }
            if ("false".equalsIgnoreCase(s)) {
                return null;
            }
            return s;
        }
        if (expr instanceof AIdentifierLevel0) {
            String s = expr.toString().trim();
            if ("true".equalsIgnoreCase(s)) {
                return null;
            }
            if ("false".equalsIgnoreCase(s)) {
                return null;
            }
            return s;
        }
        return null;
    }

    @Override
    public void outAStatement(AStatement node) {
        try {
            String id = this.getLiteral(node.getExpression());
            if (id != null) {
                Variable v = (Variable)this.module.getVariableMap().get(id);
                if (v != null) {
                    this.result = new Result(id, v.getLast());
                    return;
                }
                ListDataSet ds = (ListDataSet)this.module.getDataSetMap().get(id);
                if (ds != null) {
                    this.result = new Result(id, ds);
                    return;
                }
                Algorithm a = (Algorithm)this.module.getAlgorithmMap().get(id);
                if (a != null) {
                    this.result = new Result(id, a);
                    return;
                }
                Module m = (Module)this.module.getModuleMap().get(id);
                if (m != null) {
                    this.result = new Result(id, m);
                    return;
                }
            }
            Object o = this.getObject(node.getExpression());
            Variable v = (Variable)this.module.getVariableMap().get(ANS);
            if (v == null) {
                v = Variable.Factory.labeledVariable(ANS);
                this.module.getVariableMap().put(ANS, v);
            }
            v.add(MathUtil.getMatrix(o));
            this.result = new Result(ANS, o);
            System.out.println(this.result);
        }
        catch (Exception e) {
            this.result = new Result(e);
            e.printStackTrace();
        }
    }
}

