/*
 * Decompiled with CFR 0.152.
 */
package org.jdmp.core.sample;

import java.lang.reflect.Constructor;
import org.jdmp.core.sample.Sample;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.core.interfaces.GUIObject;
import org.ujmp.core.mapmatrix.AbstractMapMatrix;
import org.ujmp.core.util.MathUtil;
import org.ujmp.core.util.StringUtil;

public abstract class AbstractSample
extends AbstractMapMatrix<String, Object>
implements Sample {
    private static final long serialVersionUID = 1693258179407382419L;

    public AbstractSample() {
        this.setId("Sample" + this.getCoreObjectId());
    }

    @Override
    public boolean isCorrect() {
        return this.getTargetClass() == this.getRecognizedClass();
    }

    @Override
    public int getTargetClass() {
        return (int)this.getAsMatrix("Target").toRowVector(Calculation.Ret.NEW).getCoordinatesOfMaximum()[0];
    }

    @Override
    public int getRecognizedClass() {
        return (int)this.getAsMatrix("Predicted").toRowVector(Calculation.Ret.NEW).getCoordinatesOfMaximum()[0];
    }

    @Override
    public abstract Sample clone();

    @Override
    public void setLabel(Object label) {
        this.put("Label", label);
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.getClass().getSimpleName());
        s.append(" [ ");
        for (String key : this.keySet()) {
            Matrix v = this.getAsMatrix(key);
            s.append(key + "=");
            s.append(StringUtil.format(v));
            s.append(" ");
        }
        s.append("]");
        return s.toString();
    }

    @Override
    public final GUIObject getGUIObject() {
        if (this.guiObject == null) {
            try {
                Constructor<?> con = null;
                Class<?> c = Class.forName("org.jdmp.gui.sample.SampleGUIObject");
                con = c.getConstructor(Sample.class);
                this.guiObject = (GUIObject)con.newInstance(this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.guiObject;
    }

    @Override
    public final Object getAsObject(String id) {
        return this.get(id);
    }

    @Override
    public final Matrix getAsMatrix(String id) {
        return MathUtil.getMatrix(this.get(id));
    }

    @Override
    public final double getAsDouble(String id) {
        return MathUtil.getDouble(this.get(id));
    }

    @Override
    public final String getAsString(String id) {
        return StringUtil.getString(this.get(id));
    }

    @Override
    public final int getAsInt(String id) {
        return MathUtil.getInt(this.get(id));
    }

    @Override
    public final long getAsLong(String id) {
        return MathUtil.getLong(this.get(id));
    }

    @Override
    public final short getAsShort(String id) {
        return MathUtil.getShort(this.get(id));
    }

    @Override
    public final float getAsFloat(String id) {
        return MathUtil.getFloat(this.get(id));
    }

    @Override
    public final byte getAsByte(String id) {
        return MathUtil.getByte(this.get(id));
    }

    @Override
    public final char getAsChar(String id) {
        return MathUtil.getChar(this.get(id));
    }

    @Override
    public final double getWeight() {
        double weight = this.getAsDouble("Weight");
        return weight == 0.0 ? 1.0 : weight;
    }
}

