/*
 * Decompiled with CFR 0.152.
 */
package org.jdmp.core.algorithm.relationmining;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jdmp.core.algorithm.relationmining.AbstractRelationMiner;
import org.jdmp.core.algorithm.relationmining.CountMatrix;
import org.jdmp.core.dataset.DefaultListDataSet;
import org.jdmp.core.dataset.ListDataSet;
import org.jdmp.core.sample.RelationalSample;
import org.jdmp.core.sample.Sample;
import org.ujmp.core.Matrix;
import org.ujmp.core.mapmatrix.DefaultMapMatrix;
import org.ujmp.core.mapmatrix.MapMatrix;

public class MarketBasketAnalysis
extends AbstractRelationMiner {
    private final MapMatrix product1ToIds = new DefaultMapMatrix();
    private final MapMatrix product2ToIds = new DefaultMapMatrix();
    private int minSupport = 10;

    public ListDataSet calculate(ListDataSet dataSet) throws Exception {
        this.product1ToIds.setLabel("Product 1 Ids");
        this.product2ToIds.setLabel("Product 2 Ids");
        CountMatrix product1Count = new CountMatrix(this.product1ToIds);
        product1Count.setLabel("Product 1 Count");
        CountMatrix product2Count = new CountMatrix(this.product2ToIds);
        product2Count.setLabel("Product 2 Count");
        for (int r = 0; r < dataSet.size(); ++r) {
            RelationalSample s;
            Collection<?> products;
            if (r % 1000 == 0) {
                System.out.println(r + " of " + dataSet.size());
            }
            if ((products = (s = (RelationalSample)dataSet.get(r)).getObjects()).size() == 0) continue;
            this.addProduct1Count(products, r);
            this.addProduct2Count(products, r);
        }
        return this.calculateP(this.minSupport);
    }

    public static void main(String[] args) throws Exception {
        Matrix data = Matrix.Factory.linkTo().file("/home/arndt/muenchen/totale2.txt").asDenseCSV();
        DefaultListDataSet orig = new DefaultListDataSet();
        int r = 0;
        while ((long)r < data.getRowCount()) {
            Collection<?> products;
            if (r % 1000 == 0) {
                System.out.println(r + " of " + data.getRowCount());
            }
            if ((products = MarketBasketAnalysis.getProductsInLine(data, r)).size() != 0) {
                RelationalSample s = Sample.Factory.relationalSample(products);
                orig.add(s);
            }
            ++r;
        }
        MarketBasketAnalysis mba = new MarketBasketAnalysis();
        orig.showGUI();
        ListDataSet ds = mba.calculate(orig);
        ds.showGUI();
    }

    private ListDataSet calculateP(int minSupport) throws Exception {
        DefaultListDataSet ds = new DefaultListDataSet();
        for (Object o : this.product2ToIds.keySet()) {
            Set set = (Set)o;
            int count = ((List)this.product2ToIds.get(set)).size();
            if (count < minSupport) continue;
            System.out.println("===========================");
            System.out.println(set + ": " + count);
            Iterator it = set.iterator();
            String prod1 = (String)it.next();
            String prod2 = (String)it.next();
            double p1 = this.getP(prod1, prod2);
            double p2 = this.getP(prod2, prod1);
            System.out.println(prod1 + " => " + prod2 + ": " + p1);
            System.out.println(prod2 + " => " + prod1 + ": " + p2);
            RelationalSample s12 = Sample.Factory.relationalSample(prod1 + " => " + prod2);
            s12.addObject(prod1);
            s12.addObject(prod2);
            s12.put("Count", Matrix.Factory.linkToValue(count));
            s12.put("Probability", Matrix.Factory.linkToValue(p1));
            s12.put("From", prod1);
            s12.put("To", prod2);
            ds.add(s12);
            RelationalSample s21 = Sample.Factory.relationalSample(prod2 + " => " + prod1);
            s21.addObject(prod1);
            s21.addObject(prod2);
            s21.put("Count", Matrix.Factory.linkToValue(count));
            s21.put("Probability", Matrix.Factory.linkToValue(p2));
            s21.put("From", prod2);
            s21.put("To", prod1);
            ds.add(s21);
        }
        return ds;
    }

    private int getCount(String p1, String p2) {
        HashSet<String> set = new HashSet<String>(2);
        set.add(p1.intern());
        set.add(p2.intern());
        List ids = (List)this.product2ToIds.get(set);
        if (ids != null) {
            return ids.size();
        }
        return 0;
    }

    private double getP(String p1, String p2) {
        List idsSingle = (List)this.product1ToIds.get(p1.intern());
        int countTotal = 0;
        if (idsSingle != null) {
            countTotal = idsSingle.size();
        }
        int countPairwise = this.getCount(p1, p2);
        return (double)countPairwise / (double)countTotal;
    }

    private void addProduct1Count(Collection<?> products, int row) {
        if ((products = new HashSet(products)).size() < 2) {
            return;
        }
        for (Object s : products) {
            ArrayList<Integer> ids = (ArrayList<Integer>)this.product1ToIds.get(s);
            if (ids == null) {
                ids = new ArrayList<Integer>(1);
            }
            ids.add(row);
            this.product1ToIds.put(s, ids);
        }
    }

    private List<Set<?>> getPerm2(Collection<?> products) {
        ArrayList productList = new ArrayList(products);
        ArrayList permList = new ArrayList();
        for (int i1 = 0; i1 < productList.size(); ++i1) {
            for (int i2 = i1 + 1; i2 < productList.size(); ++i2) {
                HashSet product2Set = new HashSet(2);
                product2Set.add(productList.get(i1));
                product2Set.add(productList.get(i2));
                permList.add(product2Set);
            }
        }
        return permList;
    }

    private void addProduct2Count(Collection<?> products, int row) {
        if ((products = new HashSet(products)).size() < 2) {
            return;
        }
        ArrayList productList = new ArrayList(products);
        List<Set<?>> perm2 = this.getPerm2(products);
        for (Collection collection : perm2) {
            ArrayList<Integer> ids = (ArrayList<Integer>)this.product2ToIds.get(collection);
            if (ids == null) {
                ids = new ArrayList<Integer>(1);
            }
            ids.add(row);
            this.product2ToIds.put(collection, ids);
        }
    }

    private static Collection<?> getProductsInLine(Matrix data, long row) {
        HashSet<String> products = new HashSet<String>();
        int c = 1;
        while ((long)c < data.getColumnCount()) {
            String prod = data.getAsString(row, c);
            if (prod != null && (prod = prod.trim().intern()).length() != 0) {
                products.add(prod);
            }
            ++c;
        }
        return products;
    }

    public int getMinSupport() {
        return this.minSupport;
    }

    public void setMinSupport(int minSupport) {
        this.minSupport = minSupport;
    }
}

