/*
 * Decompiled with CFR 0.152.
 */
package org.jdmp.core.algorithm.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.jdmp.core.algorithm.Algorithm;
import org.jdmp.core.algorithm.index.AbstractIndex;
import org.jdmp.core.algorithm.index.Index;
import org.jdmp.core.algorithm.similarity.SimilaritySearcher;
import org.jdmp.core.dataset.ListDataSet;
import org.jdmp.core.sample.Sample;
import org.jdmp.core.util.ObservableMap;

public class MultiIndex
extends AbstractIndex
implements SimilaritySearcher {
    private static final long serialVersionUID = 3828613564416089927L;
    private ExecutorService executors = Executors.newCachedThreadPool();

    public MultiIndex(Index ... indices) {
        String label = "";
        for (int i = 0; i < indices.length; ++i) {
            this.getAlgorithmMap().put("Index" + i, (Algorithm)((Object)indices[i]));
            label = label + ((Algorithm)((Object)indices[i])).getLabel();
            if (i >= indices.length - 1) continue;
            label = label + ", ";
        }
        this.setLabel(label);
    }

    @Override
    public void add(Sample sample) throws Exception {
    }

    @Override
    public int getSize() {
        return 0;
    }

    @Override
    public ListDataSet search(String query, int start, int count) throws Exception {
        ListDataSet ds = ListDataSet.Factory.emptyDataSet();
        try {
            ArrayList<Future<ListDataSet>> futures = new ArrayList<Future<ListDataSet>>();
            for (Object k : this.getAlgorithmMap().keySet()) {
                Algorithm a = (Algorithm)this.getAlgorithmMap().get(k);
                if (!(a instanceof Index)) continue;
                futures.add(this.executors.submit(new SearchFuture((Index)((Object)a), query, start, count)));
            }
            for (Future future : futures) {
                ds.addAll((Collection)future.get());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ds;
    }

    @Override
    public ListDataSet searchSimilar(Sample sample, int start, int count) throws Exception {
        ListDataSet ds = ListDataSet.Factory.emptyDataSet();
        try {
            ArrayList<Future<ListDataSet>> futures = new ArrayList<Future<ListDataSet>>();
            for (Object k : this.getAlgorithmMap().keySet()) {
                Algorithm a = (Algorithm)this.getAlgorithmMap().get(k);
                if (!(a instanceof SimilaritySearcher)) continue;
                futures.add(this.executors.submit(new SearchSimilarFuture((SimilaritySearcher)((Object)a), sample, start, count)));
            }
            for (Future future : futures) {
                ds.addAll((Collection)future.get());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ds;
    }

    @Override
    public Sample getSample(String id) throws Exception {
        ArrayList<Future<Sample>> futures = new ArrayList<Future<Sample>>();
        for (Object key : this.getAlgorithmMap().keySet()) {
            Algorithm algorithm = (Algorithm)this.getAlgorithmMap().get(key);
            if (!(algorithm instanceof Index)) continue;
            futures.add(this.executors.submit(new GetFuture((Index)((Object)algorithm), id)));
        }
        Sample sample = null;
        for (Future future : futures) {
            Sample s = (Sample)future.get();
            if (s == null) continue;
            sample = s;
        }
        return sample;
    }

    @Override
    public final ListDataSet searchSimilar(Sample sample) throws Exception {
        return this.searchSimilar(sample, 0, 100);
    }

    @Override
    public final ListDataSet searchSimilar(Sample sample, int count) throws Exception {
        return this.searchSimilar(sample, 0, count);
    }

    public ObservableMap<Sample> getSampleMap() {
        return null;
    }

    public void setSamples(ObservableMap<Sample> samples) {
    }

    class GetFuture
    implements Callable<Sample> {
        private Index index = null;
        private String id = null;

        public GetFuture(Index index, String id) {
            this.index = index;
            this.id = id;
        }

        @Override
        public Sample call() throws Exception {
            return this.index.getSample(this.id);
        }
    }

    class SearchSimilarFuture
    implements Callable<ListDataSet> {
        private SimilaritySearcher index = null;
        private Sample sample = null;
        private int count = 0;
        private int start = 0;

        public SearchSimilarFuture(SimilaritySearcher index, Sample sample, int start, int count) {
            this.index = index;
            this.sample = sample;
            this.start = start;
            this.count = count;
        }

        @Override
        public ListDataSet call() throws Exception {
            return this.index.searchSimilar(this.sample, this.start, this.count);
        }
    }

    class SearchFuture
    implements Callable<ListDataSet> {
        private Index index = null;
        private String query = null;
        private int count = 0;
        private int start = 0;

        public SearchFuture(Index index, String query, int start, int count) {
            this.index = index;
            this.query = query;
            this.start = start;
            this.count = count;
        }

        @Override
        public ListDataSet call() throws Exception {
            return this.index.search(this.query, this.start, this.count);
        }
    }
}

