/*
 * Decompiled with CFR 0.152.
 */
package org.jdmp.core.algorithm.estimator;

import org.jdmp.core.algorithm.classification.AbstractClassifier;
import org.jdmp.core.algorithm.classification.Classifier;
import org.jdmp.core.dataset.ListDataSet;
import org.jdmp.core.sample.Sample;
import org.ujmp.core.DenseMatrix;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.Calculation;

public class MultivariateGaussianDensityEstimator
extends AbstractClassifier {
    private static final long serialVersionUID = -8923432381344117225L;
    private Matrix covarianceMatrix = null;
    private Matrix meanMatrix = null;
    private Matrix inverse = null;
    private double factor = 0.0;
    private int dimensions = 0;
    private int featureCount = 0;
    private int classCount = 0;

    @Override
    public void trainAll(ListDataSet dataSet) {
        this.featureCount = this.getFeatureCount(dataSet);
        this.classCount = this.getClassCount(dataSet);
        this.dimensions = this.featureCount + this.classCount;
        DenseMatrix x = Matrix.Factory.zeros((long)dataSet.size(), (long)this.dimensions);
        int i = 0;
        for (Sample s : dataSet) {
            Matrix input = s.getAsMatrix(this.getInputLabel()).toColumnVector(Calculation.Ret.LINK);
            for (int c = 0; c < this.featureCount; ++c) {
                x.setAsDouble(input.getAsDouble(0L, c), i, c);
            }
            Matrix target = s.getAsMatrix(this.getTargetLabel()).toColumnVector(Calculation.Ret.LINK);
            for (int c = 0; c < this.classCount; ++c) {
                x.setAsDouble(target.getAsDouble(0L, c), i, c + this.featureCount);
            }
            ++i;
        }
        this.meanMatrix = x.mean(Calculation.Ret.NEW, 0, true);
        this.covarianceMatrix = x.cov(Calculation.Ret.NEW, true, true);
        try {
            this.inverse = this.covarianceMatrix.inv();
            this.factor = 1.0 / Math.sqrt(this.covarianceMatrix.det() * Math.pow(Math.PI * 2, this.dimensions));
        }
        catch (Exception e) {
            this.inverse = this.covarianceMatrix.pinv();
            this.factor = 1.0;
        }
    }

    @Override
    public void reset() {
        this.covarianceMatrix = null;
    }

    public double getDensity(Matrix input) {
        Matrix xmean = input.minus(this.meanMatrix);
        Matrix matrix = xmean.mtimes(this.inverse).mtimes(xmean.transpose());
        return this.factor * Math.exp(-0.5 * matrix.doubleValue());
    }

    public double getDensityUnscaled(Matrix input) {
        Matrix xmean = input.minus(this.meanMatrix);
        Matrix matrix = xmean.mtimes(this.inverse).mtimes(xmean.transpose());
        return Math.exp(-0.5 * matrix.doubleValue());
    }

    @Override
    public Matrix predictOne(Matrix input) {
        int i;
        input = input.toColumnVector(Calculation.Ret.NEW);
        DenseMatrix x = Matrix.Factory.zeros(1L, (long)this.dimensions);
        for (int i2 = 0; i2 < this.featureCount; ++i2) {
            x.setAsDouble(input.getAsDouble(0L, i2), 0L, i2);
        }
        DenseMatrix result = Matrix.Factory.zeros(1L, (long)this.classCount);
        double sum = 0.0;
        for (i = 0; i < this.classCount; ++i) {
            if (i > 0) {
                x.setAsDouble(0.0, 0L, this.featureCount + i - 1);
            }
            x.setAsDouble(1.0, 0L, this.featureCount + i);
            double density = this.getDensity(x);
            result.setAsDouble(density, 0L, i);
            sum += density;
        }
        for (i = 0; i < this.classCount; ++i) {
            result.setAsDouble(result.getAsDouble(0L, i) / sum, 0L, i);
        }
        return result;
    }

    @Override
    public Classifier emptyCopy() {
        MultivariateGaussianDensityEstimator mvgd = new MultivariateGaussianDensityEstimator();
        mvgd.setInputLabel(this.getInputLabel());
        mvgd.setTargetLabel(this.getTargetLabel());
        return mvgd;
    }

    public static double getDensity(Matrix x, Matrix mean, Matrix covariance) {
        Matrix xmean = x.minus(mean);
        Matrix inverse = covariance.inv();
        double f = 1.0 / Math.sqrt(covariance.det() * Math.pow(Math.PI * 2, x.getColumnCount()));
        Matrix matrix = xmean.mtimes(inverse).mtimes(xmean.transpose());
        return f * Math.exp(-0.5 * matrix.doubleValue());
    }

    public static double getDensityUnscaled(Matrix x, Matrix mean, Matrix covariance) {
        Matrix xmean = x.minus(mean);
        Matrix inverse = covariance.inv();
        Matrix matrix = xmean.mtimes(inverse).mtimes(xmean.transpose());
        return Math.exp(-0.5 * matrix.doubleValue());
    }
}

