/*
 * Decompiled with CFR 0.152.
 */
package org.jdmp.core.algorithm.estimator;

import java.util.Arrays;
import org.jdmp.core.algorithm.estimator.AbstractDensityEstimator;

public class DiscreteDensityEstimator
extends AbstractDensityEstimator {
    private final double[] counts;
    private double sumOfCounts;

    public DiscreteDensityEstimator(int numberOfBins) {
        this(numberOfBins, 1.0);
    }

    public DiscreteDensityEstimator(int numberOfBins, boolean useLaplaceCorrection) {
        this(numberOfBins, useLaplaceCorrection ? 1.0 : 0.0);
    }

    public DiscreteDensityEstimator(int numberOfBins, double correctionFactor) {
        this.counts = new double[numberOfBins];
        this.sumOfCounts = (double)numberOfBins * correctionFactor;
        Arrays.fill(this.counts, correctionFactor);
    }

    @Override
    public void addValue(double value, double weight) {
        int n = (int)value;
        this.counts[n] = this.counts[n] + weight;
        this.sumOfCounts += weight;
    }

    @Override
    public double getProbability(double value) {
        if (this.sumOfCounts == 0.0) {
            return 1.0E-15;
        }
        double probability = this.counts[(int)value] / this.sumOfCounts;
        return probability < 1.0E-15 ? 1.0E-15 : probability;
    }

    @Override
    public void removeValue(double value, double weight) {
        int n = (int)value;
        this.counts[n] = this.counts[n] - weight;
        this.sumOfCounts -= weight;
    }
}

