/*
 * Decompiled with CFR 0.152.
 */
package org.jdmp.core.algorithm.basic;

import java.util.HashMap;
import java.util.Map;
import org.jdmp.core.algorithm.AbstractAlgorithm;
import org.jdmp.core.algorithm.Algorithm;
import org.jdmp.core.variable.Variable;
import org.ujmp.core.Matrix;
import org.ujmp.core.util.MathUtil;

public class Gauss
extends AbstractAlgorithm {
    private static final long serialVersionUID = 3127916742763698423L;
    public static final String DESCRIPTION = "target = gauss(source)";
    private final double sigma = 1.0;
    private final double mu = 0.0;

    public Gauss(Variable ... variables) {
        this.setDescription(DESCRIPTION);
        this.addVariableKey("Source");
        this.addVariableKey("Target");
        this.setEdgeLabel("Source", "Source");
        this.setEdgeLabel("Target", "Target");
        this.setEdgeDirection("Source", Algorithm.EdgeDirection.Incoming);
        this.setEdgeDirection("Target", Algorithm.EdgeDirection.Outgoing);
        this.setVariables(variables);
    }

    @Override
    public Map<String, Object> calculateObjects(Map<String, Object> input) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Matrix in = Matrix.Factory.copyFromMatrix(MathUtil.getMatrix(input.get("Source")));
        for (long[] c : in.allCoordinates()) {
            in.setAsDouble(this.getProbability(in.getAsDouble(c)), c);
        }
        result.put("Target", in);
        return result;
    }

    public double getProbability(double x) {
        return 1.0 / (1.0 * Math.sqrt(Math.PI * 2)) * Math.exp(-Math.pow(x - 0.0, 2.0) / 2.0);
    }

    public void setSourceVariable(Variable source) {
        this.setVariable("Source", source);
    }

    public void setTargetVariable(Variable target) {
        this.setVariable("Target", target);
    }
}

