/*
 * Decompiled with CFR 0.152.
 */
package org.jdmp.core.algorithm.basic;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.jdmp.core.algorithm.AbstractAlgorithm;
import org.jdmp.core.algorithm.Algorithm;
import org.jdmp.core.variable.Variable;
import org.ujmp.core.util.StringUtil;

public class Cd
extends AbstractAlgorithm {
    private static final long serialVersionUID = 9205990622002828042L;
    public static final String DESCRIPTION = "changes the directory";

    public Cd(Variable ... variables) {
        this.setDescription(DESCRIPTION);
        this.addVariableKey("Source");
        this.addVariableKey("Target");
        this.setEdgeLabel("Source", "Source");
        this.setEdgeLabel("Target", "Target");
        this.setEdgeDirection("Source", Algorithm.EdgeDirection.Incoming);
        this.setEdgeDirection("Target", Algorithm.EdgeDirection.Outgoing);
        this.setVariables(variables);
    }

    @Override
    public Map<String, Object> calculateObjects(Map<String, Object> input) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String in = StringUtil.convert(input.get("Source"));
        String ret = null;
        if (in == null || "".equals(in)) {
            ret = System.getProperty("user.home");
            System.setProperty("user.dir", ret);
        } else if (in.startsWith(".")) {
            String dir = System.getProperty("user.dir") + File.separator + in;
            File file = new File(dir);
            ret = file.getAbsolutePath();
            System.setProperty("user.dir", ret);
        } else {
            File file = new File(in);
            ret = file.getAbsolutePath();
            System.setProperty("user.dir", ret);
        }
        result.put("Target", ret);
        return result;
    }
}

