/*
 * Decompiled with CFR 0.152.
 */
package jline1;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import jline1.ArgumentCompletor;
import jline1.Completor;
import jline1.ConsoleReader;
import jline1.ConsoleReaderInputStream;
import jline1.History;

public class ConsoleRunner {
    private static ConsoleReader reader;
    public static final String property = "jline.history";

    public static ConsoleReader getReader() {
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String historyFileName = null;
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        if (argList.size() == 0) {
            ConsoleRunner.usage();
            return;
        }
        historyFileName = System.getProperty(property, null);
        String mainClass = (String)argList.remove(0);
        reader = new ConsoleReader();
        if (historyFileName != null) {
            reader.setHistory(new History(new File(System.getProperty("user.home"), ".jline-" + mainClass + "." + historyFileName + ".history")));
        } else {
            reader.setHistory(new History(new File(System.getProperty("user.home"), ".jline-" + mainClass + ".history")));
        }
        String completors = System.getProperty(ConsoleRunner.class.getName() + ".completors", "");
        ArrayList<Completor> completorList = new ArrayList<Completor>();
        StringTokenizer tok = new StringTokenizer(completors, ",");
        while (tok.hasMoreTokens()) {
            completorList.add((Completor)Class.forName(tok.nextToken()).newInstance());
        }
        if (completorList.size() > 0) {
            reader.addCompletor(new ArgumentCompletor(completorList));
        }
        ConsoleReaderInputStream.setIn(reader);
        try {
            Class.forName(mainClass).getMethod("main", String[].class).invoke(null, new Object[]{argList.toArray(new String[0])});
        }
        finally {
            ConsoleReaderInputStream.restoreIn();
        }
    }

    private static void usage() {
        System.out.println("Usage: \n   java [-Djline.history='name'] " + ConsoleRunner.class.getName() + " <target class name> [args]\n\nThe -Djline.history option will avoid history\nmangling when running ConsoleRunner on the same application.\n\nargs will be passed directly to the target class name.");
    }
}

