/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.daemon.xrootd;

import hep.io.root.daemon.xrootd.ByteFormat;
import hep.io.root.daemon.xrootd.FileStatus;
import hep.io.root.daemon.xrootd.OpenFile;
import hep.io.root.daemon.xrootd.ReadOperation;
import hep.io.root.daemon.xrootd.Session;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import jline1.Completor;
import jline1.ConsoleReader;
import jline1.History;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.ExampleMode;
import org.kohsuke.args4j.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleConsole {
    @Option(metaVar="host", name="-h", usage="Host to connect to")
    private String host;
    @Option(metaVar="port", name="-p", usage="Port to connect to")
    private int port = 1094;
    @Option(metaVar="level", name="-l", usage="Logging level")
    private String level;
    @Argument
    private List<String> arguments = new ArrayList<String>();
    private Session session;
    private static Map<String, Command> commandMap = new TreeMap<String, Command>();
    private static final ByteFormat format = new ByteFormat();

    public static void main(String[] args) throws IOException {
        new SimpleConsole().doMain(args);
    }

    private void doMain(String[] args) throws IOException {
        block9: {
            CmdLineParser parser = new CmdLineParser((Object)this);
            try {
                parser.parseArgument(args);
                if (this.host != null) {
                    this.session = new Session(this.host, this.port, System.getProperty("user.name"));
                }
                if (this.level != null) {
                    this.setLoggingLevel(this.level);
                }
                if (!this.arguments.isEmpty()) {
                    this.handleCommand(this.arguments, this, new PrintWriter(System.out, true));
                    break block9;
                }
                ReadAheadConsole console = new ReadAheadConsole();
                while (true) {
                    try {
                        String line;
                        while ((line = console.readLine(String.format("scalla%s>", this.session == null ? "" : "(" + this.session + ")"))) != null) {
                            if (line.trim().length() == 0) continue;
                            String[] tokens = line.trim().split("\\s+");
                            this.handleCommand(Arrays.asList(tokens), this, new PrintWriter(System.out, true));
                        }
                    }
                    catch (Exception x) {
                        x.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
            catch (CmdLineException e) {
                System.err.println(e.getMessage());
                System.err.printf("java %s [options...] arguments...\n", SimpleConsole.class.getName());
                parser.printUsage((OutputStream)System.err);
                System.err.println();
                System.err.printf("  Example: java %s %s\n", SimpleConsole.class.getName(), parser.printExample(ExampleMode.ALL));
                return;
            }
        }
    }

    private Session getSession() {
        return this.session;
    }

    private void setSession(Session newSession) throws IOException {
        if (this.session != null) {
            this.session.close();
        }
        this.session = newSession;
    }

    private void handleCommand(List<String> tokens, SimpleConsole session, PrintWriter console) throws SecurityException, IOException, IllegalArgumentException {
        String commandName = tokens.get(0);
        Command command = commandMap.get(commandName);
        if (command == null) {
            console.printf("Unknown command: %s\n", commandName);
        } else {
            command.doCommand(commandName, tokens.subList(1, tokens.size()), session, console);
        }
    }

    private void setLoggingLevel(String token) throws IllegalArgumentException, SecurityException {
        Level logLevel = Level.parse(token);
        Logger.getLogger("").setLevel(logLevel);
        Logger.getLogger("").getHandlers()[0].setLevel(logLevel);
    }

    private String getLoggingLevel() {
        return Logger.getLogger("").getLevel().getName();
    }

    static {
        commandMap.put("open", new OpenCommand());
        commandMap.put("close", new CloseCommand());
        commandMap.put("ping", new PingCommand());
        commandMap.put("locate", new LocateCommand());
        commandMap.put("level", new LevelCommand());
        commandMap.put("stat", new StatCommand());
        commandMap.put("exit", new ExitCommand());
        commandMap.put("quit", new ExitCommand());
        commandMap.put("dirList", new DirListCommand());
        commandMap.put("checksum", new ChecksumCommand());
        commandMap.put("stats", new StatsCommand());
        commandMap.put("get", new GetCommand());
        commandMap.put("put", new PutCommand());
        commandMap.put("connect", new ConnectCommand());
        commandMap.put("disconnect", new DisconnectCommand());
        commandMap.put("protocol", new ProtocolCommand());
        commandMap.put("help", new HelpCommand());
        commandMap.put("remove", new RemoveCommand());
    }

    private class ReadAheadConsole
    implements Runnable {
        private ConsoleReader console;
        private Thread readAheadThread = new Thread((Runnable)this, "ReadAheadConsole");
        private BlockingQueue<String> readAhead = new LinkedBlockingQueue<String>();
        private final String END_OF_DATA = new String("EOD");

        ReadAheadConsole() throws IOException {
            this.console = new ConsoleReader(System.in, new PrintWriter(System.out), ReadAheadConsole.class.getResourceAsStream("keybindings.properties"));
            File historyDir = new File(new File(System.getProperty("user.home")), ".scalla");
            historyDir.mkdir();
            File historyFile = new File(historyDir, "command.history");
            History history = historyDir.canWrite() ? new History(historyFile) : new History();
            this.console.setHistory(history);
            this.console.addCompletor(new CommandCompletor());
            this.console.addTriggeredAction('\u0003', new ControlCListener());
            this.readAheadThread.setDaemon(true);
            this.readAheadThread.start();
        }

        private String readLine(String prompt) throws IOException {
            try {
                String result;
                if (this.readAhead.isEmpty()) {
                    this.console.setDefaultPrompt(prompt);
                    this.console.redrawLine();
                    this.console.flushConsole();
                }
                if ((result = this.readAhead.take()) == this.END_OF_DATA) {
                    this.console.printNewline();
                    this.console.flushConsole();
                    return null;
                }
                return result;
            }
            catch (InterruptedException x) {
                throw new InterruptedIOException("IO Error reading console");
            }
        }

        public void run() {
            while (true) {
                try {
                    while (true) {
                        this.console.setDefaultPrompt("");
                        String result = this.console.readLine();
                        this.readAhead.offer(result == null ? this.END_OF_DATA : result);
                    }
                }
                catch (IOException iOException) {
                    continue;
                }
                break;
            }
        }
    }

    static class PutCommand
    extends Command {
        @Argument(metaVar="file", index=0, required=true, usage="Local file path")
        private File local;
        @Argument(metaVar="path", index=1, required=true, usage="Scalla file path")
        private String path;
        @Option(name="-d", usage="Open a new file, deleting any existing file")
        private boolean delete;
        @Option(name="-f", usage="Ignore file usage rules")
        private boolean force;
        @Option(name="-m", usage="Create directory path if it does not already exist")
        private boolean mkpath;
        @Option(name="-n", usage="Open a new file only if it does not already exist")
        private boolean newFile;

        PutCommand() {
        }

        void reset() {
            super.reset();
            this.newFile = false;
            this.mkpath = false;
            this.force = false;
            this.delete = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void doCommand(PrintWriter console) throws IOException {
            int options = 0;
            if (this.delete) {
                options |= 2;
            }
            if (this.force) {
                options |= 4;
            }
            if (this.mkpath) {
                options |= 0x100;
            }
            if (this.newFile) {
                options |= 8;
            }
            OpenFile file = this.getSession().open(this.path, 0, options);
            FileInputStream in = new FileInputStream(this.local);
            try {
                int l;
                byte[] buffer = new byte[65536];
                int lTotal = 0;
                while ((l = ((InputStream)in).read(buffer)) > 0) {
                    this.getSession().write(file, lTotal, buffer, 0, l);
                    lTotal += l;
                }
            }
            finally {
                this.getSession().close(file);
                ((InputStream)in).close();
            }
        }
    }

    static class GetCommand
    extends Command {
        @Argument(metaVar="source", index=0, required=true, usage="Source file")
        private String path;
        @Argument(metaVar="target", index=1, required=false, usage="Destination file")
        private File dest;
        @Option(name="-q", usage="Quiet mode")
        private boolean quiet;

        GetCommand() {
        }

        void reset() {
            super.reset();
            this.quiet = false;
            this.dest = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void doCommand(PrintWriter console) throws IOException {
            File file = new File(this.path);
            File local = this.dest == null ? new File(file.getName()) : (this.dest.isDirectory() ? new File(this.dest, file.getName()) : this.dest);
            OpenFile openFile = this.getSession().open(this.path, 0, 1040);
            FileOutputStream out = new FileOutputStream(local);
            FileChannel fileChannel = out.getChannel();
            try {
                long tStart;
                long lTotal = 0L;
                long tNext = tStart = System.currentTimeMillis();
                int bufferSize = 1000000;
                FileStatus status = openFile.getStatus();
                if (status == null) {
                    status = this.getSession().stat(this.path);
                }
                long fileSize = status.getSize();
                long offset = 0L;
                while (true) {
                    ReadOperation ro = new ReadOperation(openFile, fileChannel, offset, bufferSize);
                    int l = this.getSession().send(ro).getResponse();
                    if (l <= 0) {
                        if (!this.quiet) {
                            tNext = this.updateProgress(tNext, tStart, console, lTotal, fileSize, true);
                        }
                        break;
                    }
                    lTotal += (long)l;
                    if (!this.quiet) {
                        tNext = this.updateProgress(tNext, tStart, console, lTotal, fileSize, false);
                    }
                    offset += (long)bufferSize;
                }
            }
            finally {
                this.getSession().close(openFile);
                fileChannel.close();
                if (!this.quiet) {
                    console.println();
                }
            }
        }

        private long updateProgress(long tNext, long tStart, PrintWriter console, long current, long size, boolean finalUpdate) {
            long tNow = System.currentTimeMillis();
            if (finalUpdate || tNow > tNext) {
                int i;
                int progress = (int)(40L * current / size);
                tNext = tNow + 100L;
                long elapsed = tNow - tStart;
                console.print('[');
                for (i = 0; i < progress; ++i) {
                    console.print('*');
                }
                for (i = progress; i < 40; ++i) {
                    console.print(' ');
                }
                console.print("]  ");
                console.print(format.format(current));
                console.print('/');
                console.print(format.format(size));
                console.print("  ");
                if (finalUpdate || elapsed > 500L) {
                    console.print(format.format(1000L * current / elapsed));
                    console.print("/sec");
                }
                console.print("    \r");
                console.flush();
            }
            return tNext;
        }
    }

    static class ProtocolCommand
    extends Command {
        ProtocolCommand() {
        }

        void doCommand(PrintWriter console) throws IOException {
            String protocol = this.getSession().protocol();
            console.println(protocol);
        }
    }

    static class DisconnectCommand
    extends Command {
        DisconnectCommand() {
        }

        void doCommand(PrintWriter console) throws IOException {
            this.setSession(null);
        }
    }

    static class ConnectCommand
    extends Command {
        @Argument(metaVar="host", index=0, required=true, usage="Host to connect to")
        private String host;
        @Option(name="-p", usage="Port to connect to")
        private int port = 1094;

        ConnectCommand() {
        }

        void reset() {
            super.reset();
            this.port = 1094;
        }

        void doCommand(PrintWriter console) throws IOException {
            Session session = new Session(this.host, this.port, System.getProperty("user.name"));
            this.setSession(session);
        }
    }

    static class StatsCommand
    extends Command {
        @Argument(metaVar="arg", index=0, required=false, usage="Optional list of letters, each indicating the statistical components to be returned (default all)")
        private String arg = "a";

        StatsCommand() {
        }

        void doCommand(PrintWriter console) throws IOException {
            String result = this.getSession().query(1, this.arg);
            console.printf("%s\n", result);
        }

        void reset() {
            super.reset();
            this.arg = "a";
        }
    }

    static class ChecksumCommand
    extends Command {
        @Argument(metaVar="path", index=0, required=true, usage="Path to file")
        private String path;

        ChecksumCommand() {
        }

        void doCommand(PrintWriter console) throws IOException {
            String checksum = this.getSession().query(3, this.path);
            console.printf("%s\n", checksum);
        }
    }

    static class LocateCommand
    extends Command {
        @Argument(metaVar="path", index=0, required=true, usage="Path to locate")
        private String path;

        LocateCommand() {
        }

        void doCommand(PrintWriter console) throws IOException {
            String[] result;
            for (String file : result = this.getSession().locate(this.path, false, false)) {
                console.printf("%s\n", file);
            }
        }
    }

    static class LevelCommand
    extends Command {
        @Argument(metaVar="level", index=0, required=true, usage="Logging level")
        private String level;

        LevelCommand() {
        }

        void doCommand(PrintWriter console) throws IOException {
            this.setLoggingLevel(this.level);
        }
    }

    static class DirListCommand
    extends Command {
        @Argument(metaVar="path", index=0, required=true, usage="Path to directory")
        private String path;

        DirListCommand() {
        }

        void doCommand(PrintWriter console) throws IOException {
            List<String> list = this.getSession().dirList(this.path);
            for (String file : list) {
                console.printf("%s\n", file);
            }
        }
    }

    static class RemoveCommand
    extends Command {
        @Argument(metaVar="path", index=0, required=true, usage="Path to file")
        private String path;

        RemoveCommand() {
        }

        void doCommand(PrintWriter console) throws IOException {
            this.getSession().remove(this.path);
        }
    }

    static class StatCommand
    extends Command {
        @Argument(metaVar="path", index=0, required=true, usage="Path to file")
        private String path;

        StatCommand() {
        }

        void doCommand(PrintWriter console) throws IOException {
            FileStatus status = this.getSession().stat(this.path);
            console.printf("%s\n", status);
        }
    }

    static class ExitCommand
    extends Command {
        ExitCommand() {
        }

        void doCommand(PrintWriter console) throws IOException {
            System.exit(0);
        }
    }

    static class PingCommand
    extends Command {
        PingCommand() {
        }

        void doCommand(PrintWriter console) throws IOException {
            this.getSession().ping();
        }
    }

    static class CloseCommand
    extends Command {
        @Argument(metaVar="handle", index=0, required=true, usage="Handle to close")
        private int handle;

        CloseCommand() {
        }

        void doCommand(PrintWriter console) throws IOException {
        }
    }

    static class OpenCommand
    extends Command {
        @Argument(metaVar="path", index=0, required=true, usage="Path to open")
        private String path;
        @Option(name="-y", usage="Open the file for asynchronous i/o")
        private boolean async;
        @Option(name="-c", usage="Open a file even when compressed")
        private boolean compress;
        @Option(name="-d", usage="Open a new file, deleting any existing file")
        private boolean delete;
        @Option(name="-f", usage="Ignore file usage rules")
        private boolean force;
        @Option(name="-m", usage="Create directory path if it does not already exist")
        private boolean mkpath;
        @Option(name="-n", usage="Open a new file only if it does not already exist")
        private boolean newFile;
        @Option(name="-w", usage="Open the file only if it does not cause a wait")
        private boolean nowait;
        @Option(name="-a", usage="Open only for appending")
        private boolean open_apnd;
        @Option(name="-r", usage="Open only for reading")
        private boolean open_read;
        @Option(name="-u", usage="Open for reading and writing")
        private boolean open_updt;
        @Option(name="-e", usage="Update cached information on the file's location ")
        private boolean refresh;
        @Option(name="-p", usage="The file is being opened for replica creation")
        private boolean replica;
        @Option(name="-s", usage="Return file status information in the response")
        private boolean retstat;
        @Option(name="-h", usage="Hide the file until successfully closed")
        private boolean ulterior;

        OpenCommand() {
        }

        void reset() {
            super.reset();
            this.ulterior = false;
            this.retstat = false;
            this.replica = false;
            this.refresh = false;
            this.open_updt = false;
            this.open_read = false;
            this.open_apnd = false;
            this.nowait = false;
            this.newFile = false;
            this.mkpath = false;
            this.force = false;
            this.delete = false;
            this.compress = false;
            this.async = false;
        }

        void doCommand(PrintWriter console) throws IOException {
            int options = 0;
            if (this.async) {
                options |= 0x40;
            }
            if (this.compress) {
                options |= 1;
            }
            if (this.delete) {
                options |= 2;
            }
            if (this.force) {
                options |= 4;
            }
            if (this.mkpath) {
                options |= 0x100;
            }
            if (this.newFile) {
                options |= 8;
            }
            if (this.nowait) {
                options |= 0x2000;
            }
            if (this.open_apnd) {
                options |= 0x200;
            }
            if (this.open_read) {
                options |= 0x10;
            }
            if (this.open_updt) {
                options |= 0x20;
            }
            if (this.refresh) {
                options |= 0x80;
            }
            if (this.replica) {
                options |= 0x800;
            }
            if (this.retstat) {
                options |= 0x400;
            }
            if (this.ulterior) {
                options |= 0x1000;
            }
        }
    }

    static class HelpCommand
    extends Command {
        @Argument(metaVar="command", index=0, usage="Command for which help is requested")
        private String commandName;

        HelpCommand() {
        }

        void reset() {
            super.reset();
            this.commandName = null;
        }

        void doCommand(PrintWriter console) throws IOException {
            if (this.commandName == null) {
                for (Map.Entry entry : commandMap.entrySet()) {
                    console.printf("%s %s\n", entry.getKey(), ((Command)entry.getValue()).printExample());
                }
            } else {
                Command command = (Command)commandMap.get(this.commandName);
                if (command == null) {
                    console.printf("Unknown command: %s\n", this.commandName);
                } else {
                    command.printHelp(console);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class Command {
        @Option(metaVar="level", name="-l", usage="Set logging level for this command")
        private String level;
        private SimpleConsole simpleConsole;

        Command() {
        }

        Session getSession() {
            if (this.simpleConsole.getSession() == null) {
                throw new RuntimeException("No session");
            }
            return this.simpleConsole.getSession();
        }

        void setLoggingLevel(String level) {
            this.simpleConsole.setLoggingLevel(level);
        }

        void setSession(Session session) throws IOException {
            this.simpleConsole.setSession(session);
        }

        String printExample() {
            return new CmdLineParser((Object)this).printExample(ExampleMode.ALL);
        }

        abstract void doCommand(PrintWriter var1) throws IOException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void doCommand(String command, List<String> args, SimpleConsole session, PrintWriter console) throws IOException {
            block6: {
                this.reset();
                CmdLineParser parser = new CmdLineParser((Object)this);
                try {
                    parser.parseArgument(args.toArray(new String[args.size()]));
                    this.simpleConsole = session;
                    if (this.level != null) {
                        String oldLevel = this.simpleConsole.getLoggingLevel();
                        try {
                            this.setLoggingLevel(this.level);
                            this.doCommand(console);
                            break block6;
                        }
                        finally {
                            this.setLoggingLevel(oldLevel);
                        }
                    }
                    this.doCommand(console);
                }
                catch (CmdLineException e) {
                    System.err.println(e.getMessage());
                    System.err.printf("%s [options...] arguments...\n", command);
                    parser.printUsage((OutputStream)System.err);
                    System.err.println();
                    System.err.printf("  Example: %s %s\n", command, parser.printExample(ExampleMode.ALL));
                }
            }
        }

        private void printHelp(Writer writer) {
            new CmdLineParser((Object)this).printUsage(writer, null);
        }

        void reset() {
            this.level = null;
        }
    }

    static class ControlCListener
    implements ActionListener {
        ControlCListener() {
        }

        public void actionPerformed(ActionEvent e) {
            System.err.println("ctrlc");
        }
    }

    static class CommandCompletor
    implements Completor {
        CommandCompletor() {
        }

        public int complete(String buffer, int position, List candidates) {
            if (buffer.contains(" ")) {
                return 0;
            }
            for (String command : commandMap.keySet()) {
                if (!command.startsWith(buffer)) continue;
                candidates.add(command + " ");
            }
            return 0;
        }
    }
}

