/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.daemon.xrootd;

import hep.io.root.daemon.xrootd.Callback;
import hep.io.root.daemon.xrootd.Destination;
import hep.io.root.daemon.xrootd.Message;
import hep.io.root.daemon.xrootd.Multiplexor;
import hep.io.root.daemon.xrootd.OpenFile;
import hep.io.root.daemon.xrootd.OpenOperation;
import hep.io.root.daemon.xrootd.Operation;
import java.io.IOException;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CloseOperation
extends Operation<Void> {
    private OpenFile file;

    CloseOperation(OpenFile file) {
        super("close", new CloseMessage(file), new Callback.DefaultCallback());
        this.file = file;
    }

    @Override
    Destination getDestination() {
        return this.file.getDestination();
    }

    @Override
    Operation getPrerequisite() {
        return new OpenOperation(this.file);
    }

    @Override
    Multiplexor getMultiplexor() {
        return this.file.getMultiplexor();
    }

    private static class CloseMessage
    extends Message {
        private OpenFile file;

        CloseMessage(OpenFile file) {
            super(3003);
            this.file = file;
        }

        void writeExtra(ByteBuffer out) throws IOException {
            out.putInt(this.file.getHandle());
        }
    }
}

