/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.struct;

import java.util.List;
import org.ddogleg.struct.DummyData;
import org.ddogleg.struct.FastQueue;
import org.junit.Assert;
import org.junit.Test;

public class TestFastQueue {
    @Test
    public void checkDeclareInstance() {
        FastQueue<DummyData> alg = new FastQueue<DummyData>(10, DummyData.class, true);
        Assert.assertTrue((alg.getMaxSize() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((((DummyData[])alg.data)[0] != null ? 1 : 0) != 0);
        alg = new FastQueue<DummyData>(10, DummyData.class, false);
        Assert.assertTrue((alg.getMaxSize() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((((DummyData[])alg.data)[0] == null ? 1 : 0) != 0);
    }

    @Test
    public void toList() {
        FastQueue<DummyData> alg = new FastQueue<DummyData>(10, DummyData.class, true);
        List<DummyData> l = alg.toList();
        Assert.assertEquals((long)0L, (long)l.size());
        alg.grow().value = 1;
        alg.grow().value = 1;
        alg.grow().value = 2;
        alg.removeTail();
        l = alg.toList();
        Assert.assertEquals((long)2L, (long)l.size());
        Assert.assertEquals((long)1L, (long)l.get((int)0).value);
        Assert.assertEquals((long)1L, (long)l.get((int)1).value);
    }

    @Test
    public void removeTail() {
        FastQueue<DummyData> alg = new FastQueue<DummyData>(10, DummyData.class, true);
        alg.grow();
        Assert.assertEquals((long)1L, (long)alg.size);
        alg.removeTail();
        Assert.assertEquals((long)0L, (long)alg.size);
    }

    @Test
    public void remove() {
        FastQueue<DummyData> alg = new FastQueue<DummyData>(10, DummyData.class, true);
        List<DummyData> l = alg.toList();
        Assert.assertEquals((long)0L, (long)l.size());
        alg.grow().value = 1;
        alg.grow().value = 2;
        alg.grow().value = 3;
        alg.remove(1);
        Assert.assertEquals((long)2L, (long)alg.size());
        Assert.assertEquals((long)1L, (long)alg.get((int)0).value);
        Assert.assertEquals((long)3L, (long)alg.get((int)1).value);
        Assert.assertEquals((long)2L, (long)((DummyData[])alg.data)[2].value);
        alg.remove(1);
        Assert.assertEquals((long)1L, (long)alg.size());
        Assert.assertEquals((long)1L, (long)alg.get((int)0).value);
        Assert.assertEquals((long)3L, (long)((DummyData[])alg.data)[1].value);
        Assert.assertEquals((long)2L, (long)((DummyData[])alg.data)[2].value);
        alg.remove(0);
        Assert.assertEquals((long)0L, (long)alg.size());
        Assert.assertEquals((long)1L, (long)((DummyData[])alg.data)[0].value);
        Assert.assertEquals((long)3L, (long)((DummyData[])alg.data)[1].value);
        Assert.assertEquals((long)2L, (long)((DummyData[])alg.data)[2].value);
    }

    @Test
    public void getTail() {
        FastQueue<DummyData> alg = new FastQueue<DummyData>(10, DummyData.class, true);
        alg.grow();
        alg.grow();
        Assert.assertTrue((((DummyData[])alg.data)[1] == alg.getTail() ? 1 : 0) != 0);
    }

    @Test
    public void getTail_index() {
        FastQueue<DummyData> alg = new FastQueue<DummyData>(10, DummyData.class, true);
        alg.grow();
        alg.grow();
        for (int i = 0; i < alg.size(); ++i) {
            Assert.assertTrue((((DummyData[])alg.data)[i] == alg.getTail(alg.size - i - 1) ? 1 : 0) != 0);
        }
    }

    @Test
    public void get_pop() {
        FastQueue<DummyData> alg = new FastQueue<DummyData>(DummyData.class, true);
        try {
            alg.get(0);
            Assert.fail((String)"Didn't fail");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        alg.grow();
        alg.get(0);
    }

    @Test
    public void size() {
        FastQueue<DummyData> alg = new FastQueue<DummyData>(DummyData.class, true);
        Assert.assertEquals((long)0L, (long)alg.size);
        alg.grow();
        Assert.assertEquals((long)1L, (long)alg.size);
    }

    @Test
    public void add() {
        FastQueue<DummyData> alg = new FastQueue<DummyData>(DummyData.class, false);
        DummyData a = new DummyData();
        alg.add(a);
        Assert.assertTrue((a == ((DummyData[])alg.data)[0] ? 1 : 0) != 0);
    }

    @Test
    public void reverse() {
        FastQueue<DummyData> alg = new FastQueue<DummyData>(2, DummyData.class, true);
        alg.reverse();
        Assert.assertEquals((long)0L, (long)alg.size());
        alg.grow().value = 1;
        alg.reverse();
        Assert.assertEquals((long)1L, (long)alg.get((int)0).value);
        alg.grow().value = 2;
        alg.reverse();
        Assert.assertEquals((long)2L, (long)alg.get((int)0).value);
        Assert.assertEquals((long)1L, (long)alg.get((int)1).value);
        alg.reset();
        alg.grow().value = 1;
        alg.grow().value = 2;
        alg.grow().value = 3;
        alg.reverse();
        Assert.assertEquals((long)3L, (long)alg.get((int)0).value);
        Assert.assertEquals((long)2L, (long)alg.get((int)1).value);
        Assert.assertEquals((long)1L, (long)alg.get((int)2).value);
        alg.reset();
        alg.grow().value = 1;
        alg.grow().value = 2;
        alg.grow().value = 3;
        alg.grow().value = 4;
        alg.reverse();
        Assert.assertEquals((long)4L, (long)alg.get((int)0).value);
        Assert.assertEquals((long)3L, (long)alg.get((int)1).value);
        Assert.assertEquals((long)2L, (long)alg.get((int)2).value);
        Assert.assertEquals((long)1L, (long)alg.get((int)3).value);
        alg.reverse();
        Assert.assertEquals((long)1L, (long)alg.get((int)0).value);
        Assert.assertEquals((long)2L, (long)alg.get((int)1).value);
        Assert.assertEquals((long)3L, (long)alg.get((int)2).value);
        Assert.assertEquals((long)4L, (long)alg.get((int)3).value);
    }

    @Test
    public void addAll() {
        FastQueue<DummyData> alg = new FastQueue<DummyData>(DummyData.class, true);
        alg.grow();
        alg.grow();
        FastQueue<DummyData> alg2 = new FastQueue<DummyData>(DummyData.class, false);
        alg2.addAll(alg);
        Assert.assertTrue((alg.get(0) == alg2.get(0) ? 1 : 0) != 0);
        Assert.assertTrue((alg.get(1) == alg2.get(1) ? 1 : 0) != 0);
    }

    @Test
    public void pop_grow() {
        FastQueue<DummyData> alg = new FastQueue<DummyData>(1, DummyData.class, true);
        int before = alg.getMaxSize();
        for (int i = 0; i < 20; ++i) {
            alg.grow();
        }
        alg.get(19);
        int after = alg.getMaxSize();
        Assert.assertTrue((after > before ? 1 : 0) != 0);
    }

    @Test
    public void growArray() {
        FastQueue<DummyData> alg = new FastQueue<DummyData>(1, DummyData.class, true);
        alg.grow().value = 10;
        int before = alg.getMaxSize();
        alg.growArray(before + 5);
        Assert.assertEquals((long)10L, (long)alg.get((int)0).value);
    }

    @Test
    public void contains() {
        FastQueue<Double> queue = new FastQueue<Double>(100, Double.class, false);
        Double d = 1.0;
        Assert.assertFalse((boolean)queue.contains(d));
        queue.add(d);
        Assert.assertTrue((boolean)queue.contains(d));
    }
}

