/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.struct;

import java.util.List;
import java.util.Stack;

public class LinkedList<T> {
    Element first;
    Element last;
    int size;
    Stack<Element> available = new Stack();

    public void reset() {
        Element e = this.first;
        while (e != null) {
            Element n = e.next;
            e.clear();
            this.available.add(e);
            e = n;
        }
        this.last = null;
        this.first = null;
        this.size = 0;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public Element getElement(int index, boolean fromFront) {
        if (index > this.size || index < 0) {
            throw new IllegalArgumentException("index is out of bounds");
        }
        if (fromFront) {
            Element e = this.first;
            for (int i = 0; i < index; ++i) {
                e = e.next;
            }
            return e;
        }
        Element e = this.last;
        for (int i = 0; i < index; ++i) {
            e = e.previous;
        }
        return e;
    }

    public Element pushHead(T object) {
        Element e = this.requestNew();
        e.object = object;
        if (this.first == null) {
            this.first = this.last = e;
        } else {
            e.next = this.first;
            this.first.previous = e;
            this.first = e;
        }
        ++this.size;
        return e;
    }

    public Element pushTail(T object) {
        Element e = this.requestNew();
        e.object = object;
        if (this.last == null) {
            this.first = this.last = e;
        } else {
            e.previous = this.last;
            this.last.next = e;
            this.last = e;
        }
        ++this.size;
        return e;
    }

    public Element insertAfter(Element previous, T object) {
        Element e = this.requestNew();
        e.object = object;
        e.previous = previous;
        e.next = previous.next;
        if (e.next != null) {
            e.next.previous = e;
        } else {
            this.last = e;
        }
        previous.next = e;
        ++this.size;
        return e;
    }

    public Element insertBefore(Element next, T object) {
        Element e = this.requestNew();
        e.object = object;
        e.previous = next.previous;
        e.next = next;
        if (e.previous != null) {
            e.previous.next = e;
        } else {
            this.first = e;
        }
        next.previous = e;
        ++this.size;
        return e;
    }

    public void swap(Element a, Element b) {
        if (a.next == b) {
            if (a.previous != null) {
                a.previous.next = b;
            }
            if (b.next != null) {
                b.next.previous = a;
            }
            Element tmp = a.previous;
            a.previous = b;
            a.next = b.next;
            b.previous = tmp;
            b.next = a;
            if (this.first == a) {
                this.first = b;
            }
            if (this.last == b) {
                this.last = a;
            }
        } else if (a.previous == b) {
            if (a.next != null) {
                a.next.previous = b;
            }
            if (b.previous != null) {
                b.previous.next = a;
            }
            Element tmp = a.next;
            a.next = b;
            a.previous = b.previous;
            b.previous = a;
            b.next = tmp;
            if (this.first == b) {
                this.first = a;
            }
            if (this.last == a) {
                this.last = b;
            }
        } else {
            if (a.next != null) {
                a.next.previous = b;
            }
            if (a.previous != null) {
                a.previous.next = b;
            }
            if (b.next != null) {
                b.next.previous = a;
            }
            if (b.previous != null) {
                b.previous.next = a;
            }
            Element tempNext = b.next;
            Element tempPrev = b.previous;
            b.next = a.next;
            b.previous = a.previous;
            a.next = tempNext;
            a.previous = tempPrev;
            if (a.next == null) {
                this.last = a;
            } else if (b.next == null) {
                this.last = b;
            }
            if (a.previous == null) {
                this.first = a;
            } else if (b.previous == null) {
                this.first = b;
            }
        }
    }

    public void remove(Element element) {
        if (element.next == null) {
            this.last = element.previous;
        } else {
            element.next.previous = element.previous;
        }
        if (element.previous == null) {
            this.first = element.next;
        } else {
            element.previous.next = element.next;
        }
        --this.size;
        element.clear();
        this.available.push(element);
    }

    public Object removeHead() {
        if (this.first == null) {
            throw new IllegalArgumentException("Empty list");
        }
        Object ret = this.first.getObject();
        Element e = this.first;
        this.available.push(this.first);
        if (this.first.next != null) {
            this.first.next.previous = null;
            this.first = this.first.next;
        } else {
            this.last = null;
            this.first = null;
        }
        e.clear();
        --this.size;
        return ret;
    }

    public Object removeTail() {
        if (this.last == null) {
            throw new IllegalArgumentException("Empty list");
        }
        Object ret = this.last.getObject();
        Element e = this.last;
        this.available.add(this.last);
        if (this.last.previous != null) {
            this.last.previous.next = null;
            this.last = this.last.previous;
        } else {
            this.last = null;
            this.first = null;
        }
        e.clear();
        --this.size;
        return ret;
    }

    public Element find(T object) {
        Element e = this.first;
        while (e != null) {
            if (e.object == object) {
                return e;
            }
            e = e.next;
        }
        return null;
    }

    public Element getHead() {
        return this.first;
    }

    public Element getTail() {
        return this.last;
    }

    public void addAll(List<T> list) {
        if (list.isEmpty()) {
            return;
        }
        Element a = this.requestNew();
        a.object = list.get(0);
        if (this.first == null) {
            this.first = a;
        } else if (this.last != null) {
            this.last.next = a;
            a.previous = this.last;
        }
        for (int i = 1; i < list.size(); ++i) {
            Element b = this.requestNew();
            b.object = list.get(i);
            a.next = b;
            b.previous = a;
            a = b;
        }
        this.last = a;
        this.size += list.size();
    }

    public void addAll(T[] array, int first, int length) {
        if (length <= 0) {
            return;
        }
        Element a = this.requestNew();
        a.object = array[first];
        if (this.first == null) {
            this.first = a;
        } else if (this.last != null) {
            this.last.next = a;
            a.previous = this.last;
        }
        for (int i = 1; i < length; ++i) {
            Element b = this.requestNew();
            b.object = array[first + i];
            a.next = b;
            b.previous = a;
            a = b;
        }
        this.last = a;
        this.size += length;
    }

    public int size() {
        return this.size;
    }

    protected Element requestNew() {
        if (this.available.isEmpty()) {
            return new Element();
        }
        return this.available.pop();
    }

    public static class Element {
        public Element next;
        public Element previous;
        public Object object;

        public void clear() {
            this.next = null;
            this.previous = null;
            this.object = null;
        }

        public Element getNext() {
            return this.next;
        }

        public void setNext(Element next) {
            this.next = next;
        }

        public Element getPrevious() {
            return this.previous;
        }

        public void setPrevious(Element previous) {
            this.previous = previous;
        }

        public Object getObject() {
            return this.object;
        }

        public void setObject(Object object) {
            this.object = object;
        }
    }
}

