/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.struct;

import java.util.Arrays;

public class GrowQueue_I64 {
    public long[] data;
    public int size;

    public GrowQueue_I64(int maxSize) {
        this.data = new long[maxSize];
        this.size = 0;
    }

    public GrowQueue_I64() {
        this(10);
    }

    public void reset() {
        this.size = 0;
    }

    public void addAll(GrowQueue_I64 queue) {
        if (this.size + queue.size > this.data.length) {
            long[] temp = new long[(this.size + queue.size) * 2];
            System.arraycopy(this.data, 0, temp, 0, this.size);
            this.data = temp;
        }
        System.arraycopy(queue.data, 0, this.data, this.size, queue.size);
        this.size += queue.size;
    }

    public void addAll(long[] array, int startIndex, int endIndex) {
        if (endIndex > array.length) {
            throw new IllegalAccessError("endIndex is larger than input array");
        }
        int arraySize = endIndex - startIndex;
        if (this.size + arraySize > this.data.length) {
            long[] temp = new long[(this.size + arraySize) * 2];
            System.arraycopy(this.data, 0, temp, 0, this.size);
            this.data = temp;
        }
        System.arraycopy(array, startIndex, this.data, this.size, arraySize);
        this.size += arraySize;
    }

    public void add(long value) {
        this.push(value);
    }

    public void push(long val) {
        if (this.size == this.data.length) {
            long[] temp = new long[this.size * 2];
            System.arraycopy(this.data, 0, temp, 0, this.size);
            this.data = temp;
        }
        this.data[this.size++] = val;
    }

    public long get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("index = " + index + "  size = " + this.size);
        }
        return this.data[index];
    }

    public long unsafe_get(int index) {
        return this.data[index];
    }

    public void set(int index, long value) {
        this.data[index] = value;
    }

    public void setTo(GrowQueue_I64 original) {
        this.resize(original.size);
        System.arraycopy(original.data, 0, this.data, 0, this.size());
    }

    public void remove(int index) {
        for (int i = index + 1; i < this.size; ++i) {
            this.data[i - 1] = this.data[i];
        }
        --this.size;
    }

    public void insert(int index, long value) {
        if (this.size == this.data.length) {
            long[] temp = new long[this.size * 2];
            System.arraycopy(this.data, 0, temp, 0, index);
            temp[index] = value;
            System.arraycopy(this.data, index, temp, index + 1, this.size - index);
            this.data = temp;
            ++this.size;
        } else {
            ++this.size;
            for (int i = this.size - 1; i > index; --i) {
                this.data[i] = this.data[i - 1];
            }
            this.data[index] = value;
        }
    }

    public long removeTail() {
        if (this.size > 0) {
            --this.size;
            return this.data[this.size];
        }
        throw new RuntimeException("Size zero, no tail");
    }

    public void resize(int size) {
        if (this.data.length < size) {
            this.data = new long[size];
        }
        this.size = size;
    }

    public void fill(long value) {
        Arrays.fill(this.data, 0, this.size, value);
    }

    public void setMaxSize(int size) {
        if (this.data.length < size) {
            this.data = new long[size];
        }
    }

    public int size() {
        return this.size;
    }

    public long pop() {
        return this.data[--this.size];
    }
}

