/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.struct;

import java.util.Arrays;

public class GrowQueue_F64 {
    public double[] data;
    public int size;

    public GrowQueue_F64(int maxSize) {
        this.data = new double[maxSize];
        this.size = 0;
    }

    public GrowQueue_F64() {
        this(10);
    }

    public void reset() {
        this.size = 0;
    }

    public void addAll(GrowQueue_F64 queue) {
        if (this.size + queue.size > this.data.length) {
            double[] temp = new double[(this.size + queue.size) * 2];
            System.arraycopy(this.data, 0, temp, 0, this.size);
            this.data = temp;
        }
        System.arraycopy(queue.data, 0, this.data, this.size, queue.size);
        this.size += queue.size;
    }

    public void addAll(double[] array, int startIndex, int endIndex) {
        if (endIndex > array.length) {
            throw new IllegalAccessError("endIndex is larger than input array");
        }
        int arraySize = endIndex - startIndex;
        if (this.size + arraySize > this.data.length) {
            double[] temp = new double[(this.size + arraySize) * 2];
            System.arraycopy(this.data, 0, temp, 0, this.size);
            this.data = temp;
        }
        System.arraycopy(array, startIndex, this.data, this.size, arraySize);
        this.size += arraySize;
    }

    public void add(double val) {
        this.push(val);
    }

    public void push(double val) {
        if (this.size == this.data.length) {
            double[] temp;
            try {
                temp = new double[this.size * 2];
            }
            catch (OutOfMemoryError e) {
                System.gc();
                temp = new double[3 * this.size / 2];
            }
            System.arraycopy(this.data, 0, temp, 0, this.size);
            this.data = temp;
        }
        this.data[this.size++] = val;
    }

    public void remove(int index) {
        for (int i = index + 1; i < this.size; ++i) {
            this.data[i - 1] = this.data[i];
        }
        --this.size;
    }

    public void insert(int index, double value) {
        if (this.size == this.data.length) {
            double[] temp = new double[this.size * 2];
            System.arraycopy(this.data, 0, temp, 0, index);
            temp[index] = value;
            System.arraycopy(this.data, index, temp, index + 1, this.size - index);
            this.data = temp;
            ++this.size;
        } else {
            ++this.size;
            for (int i = this.size - 1; i > index; --i) {
                this.data[i] = this.data[i - 1];
            }
            this.data[index] = value;
        }
    }

    public double removeTail() {
        if (this.size > 0) {
            --this.size;
            return this.data[this.size];
        }
        throw new RuntimeException("Size zero, no tail");
    }

    public double get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("index = " + index + "  size = " + this.size);
        }
        return this.data[index];
    }

    public double unsafe_get(int index) {
        return this.data[index];
    }

    public void set(int index, double value) {
        this.data[index] = value;
    }

    public void setTo(GrowQueue_F64 original) {
        this.resize(original.size);
        System.arraycopy(original.data, 0, this.data, 0, this.size());
    }

    public void resize(int size) {
        if (this.data.length < size) {
            this.data = new double[size];
        }
        this.size = size;
    }

    public void fill(double value) {
        Arrays.fill(this.data, 0, this.size, value);
    }

    public void setMaxSize(int size) {
        if (this.data.length < size) {
            this.data = new double[size];
        }
    }

    public int size() {
        return this.size;
    }

    public double pop() {
        return this.data[--this.size];
    }
}

