/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.sorting;

import java.util.Random;
import org.ddogleg.sorting.BenchMarkSort;
import org.ddogleg.sorting.QuickSort_F64;
import org.ddogleg.util.UtilDouble;
import org.junit.Assert;
import org.junit.Test;

public class TestQuickSort_F64 {
    Random rand = new Random(1044180L);

    @Test
    public void testSortingRandom() {
        double[] ret = BenchMarkSort.createRandom(this.rand, 200);
        double preTotal = UtilDouble.sum(ret);
        QuickSort_F64 sorter = new QuickSort_F64();
        sorter.sort(ret, ret.length);
        double postTotal = UtilDouble.sum(ret);
        Assert.assertEquals((double)preTotal, (double)postTotal, (double)1.0E-8);
        double prev = ret[0];
        for (int i = 1; i < ret.length; ++i) {
            if (ret[i] < prev) {
                Assert.fail((String)"Not ascending");
            }
            prev = ret[i];
        }
    }

    @Test
    public void testSortingRandom_indexes() {
        for (int a = 0; a < 20; ++a) {
            double[] normal = BenchMarkSort.createRandom(this.rand, 20);
            double[] original = (double[])normal.clone();
            double[] withIndexes = (double[])normal.clone();
            int[] indexes = new int[normal.length];
            QuickSort_F64 sorter = new QuickSort_F64();
            sorter.sort(normal, normal.length);
            sorter.sort(withIndexes, normal.length, indexes);
            for (int i = 0; i < normal.length; ++i) {
                Assert.assertEquals((double)original[i], (double)withIndexes[i], (double)1.0E-8);
                Assert.assertEquals((double)normal[i], (double)withIndexes[indexes[i]], (double)1.0E-8);
            }
        }
    }
}

