/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.sorting;

import java.util.Arrays;
import java.util.Random;
import org.ddogleg.sorting.QuickSelect;
import org.junit.Assert;
import org.junit.Test;

public class TestQuickSelect {
    Random rand = new Random(255L);

    @Test
    public void testWithQuickSort() {
        int i;
        Comparable[] orig = new Comparable[100];
        Comparable[] copy = new Comparable[orig.length];
        Object[] sorted = new Comparable[orig.length];
        for (i = 0; i < orig.length; ++i) {
            orig[i] = Double.valueOf(this.rand.nextDouble());
            sorted[i] = orig[i];
        }
        Arrays.sort(sorted);
        for (i = 0; i < orig.length; ++i) {
            System.arraycopy(orig, 0, copy, 0, orig.length);
            QuickSelect.select(copy, i, copy.length);
            Assert.assertEquals((Object)sorted[i], (Object)copy[i]);
        }
    }

    @Test
    public void testWithQuickSortIndex() {
        int i;
        Comparable[] orig = new Comparable[100];
        Comparable[] copy = new Comparable[orig.length];
        Object[] sorted = new Comparable[orig.length];
        int[] indexes = new int[orig.length];
        for (i = 0; i < orig.length; ++i) {
            orig[i] = Double.valueOf(this.rand.nextDouble());
            sorted[i] = orig[i];
        }
        Arrays.sort(sorted);
        for (i = 0; i < orig.length; ++i) {
            System.arraycopy(orig, 0, copy, 0, orig.length);
            QuickSelect.select(copy, i, copy.length, indexes);
            Assert.assertEquals((Object)orig[i], (Object)copy[i]);
            Assert.assertEquals((Object)sorted[i], (Object)copy[indexes[i]]);
        }
    }

    @Test
    public void testWithQuickSort_F64() {
        int i;
        double[] orig = new double[100];
        double[] copy = new double[orig.length];
        double[] sorted = new double[orig.length];
        for (i = 0; i < orig.length; ++i) {
            orig[i] = this.rand.nextDouble();
            sorted[i] = orig[i];
        }
        Arrays.sort(sorted);
        for (i = 0; i < orig.length; ++i) {
            int j;
            System.arraycopy(orig, 0, copy, 0, orig.length);
            double val = QuickSelect.select(copy, i, copy.length);
            Assert.assertEquals((double)sorted[i], (double)copy[i], (double)1.0E-6);
            for (j = 0; j < i; ++j) {
                Assert.assertTrue((copy[j] <= val ? 1 : 0) != 0);
            }
            for (j = i + 1; j < copy.length; ++j) {
                Assert.assertTrue((copy[j] > val ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testWithQuickSort_I32() {
        int i;
        int[] orig = new int[100];
        int[] copy = new int[orig.length];
        int[] sorted = new int[orig.length];
        for (i = 0; i < orig.length; ++i) {
            orig[i] = this.rand.nextInt(5000);
            sorted[i] = orig[i];
        }
        Arrays.sort(sorted);
        for (i = 0; i < orig.length; ++i) {
            int j;
            System.arraycopy(orig, 0, copy, 0, orig.length);
            double val = QuickSelect.select(copy, i, copy.length);
            Assert.assertEquals((double)sorted[i], (double)copy[i], (double)1.0E-6);
            for (j = 0; j < i; ++j) {
                Assert.assertTrue(((double)copy[j] <= val ? 1 : 0) != 0);
            }
            for (j = i + 1; j < copy.length; ++j) {
                Assert.assertTrue(((double)copy[j] > val ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testWithQuickSort_I64() {
        int i;
        long[] orig = new long[100];
        long[] copy = new long[orig.length];
        long[] sorted = new long[orig.length];
        for (i = 0; i < orig.length; ++i) {
            orig[i] = this.rand.nextInt(5000);
            sorted[i] = orig[i];
        }
        Arrays.sort(sorted);
        for (i = 0; i < orig.length; ++i) {
            int j;
            System.arraycopy(orig, 0, copy, 0, orig.length);
            double val = QuickSelect.select(copy, i, copy.length);
            Assert.assertEquals((double)sorted[i], (double)copy[i], (double)1.0E-6);
            for (j = 0; j < i; ++j) {
                Assert.assertTrue(((double)copy[j] <= val ? 1 : 0) != 0);
            }
            for (j = i + 1; j < copy.length; ++j) {
                Assert.assertTrue(((double)copy[j] > val ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testWithQuickSortIndex_F64() {
        int i;
        double[] orig = new double[100];
        double[] copy = new double[orig.length];
        double[] sorted = new double[orig.length];
        int[] indexes = new int[orig.length];
        for (i = 0; i < orig.length; ++i) {
            orig[i] = this.rand.nextDouble();
            sorted[i] = orig[i];
        }
        Arrays.sort(sorted);
        for (i = 0; i < orig.length; ++i) {
            int j;
            System.arraycopy(orig, 0, copy, 0, orig.length);
            int index = QuickSelect.selectIndex(copy, i, copy.length, indexes);
            Assert.assertEquals((double)sorted[i], (double)orig[index], (double)1.0E-6);
            double val = orig[index];
            for (j = 0; j < copy.length; ++j) {
                Assert.assertEquals((double)orig[j], (double)copy[j], (double)1.0E-8);
            }
            for (j = 0; j < i; ++j) {
                Assert.assertTrue((orig[indexes[j]] <= val ? 1 : 0) != 0);
            }
            for (j = i + 1; j < copy.length; ++j) {
                Assert.assertTrue((orig[indexes[j]] > val ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testWithQuickSortIndex_I32() {
        int i;
        int[] orig = new int[100];
        int[] copy = new int[orig.length];
        int[] sorted = new int[orig.length];
        int[] indexes = new int[orig.length];
        for (i = 0; i < orig.length; ++i) {
            orig[i] = this.rand.nextInt(6000);
            sorted[i] = orig[i];
        }
        Arrays.sort(sorted);
        for (i = 0; i < orig.length; ++i) {
            int j;
            System.arraycopy(orig, 0, copy, 0, orig.length);
            int index = QuickSelect.selectIndex(copy, i, copy.length, indexes);
            Assert.assertEquals((double)sorted[i], (double)orig[index], (double)1.0E-6);
            double val = orig[index];
            for (j = 0; j < copy.length; ++j) {
                Assert.assertEquals((long)orig[j], (long)copy[j]);
            }
            for (j = 0; j < i; ++j) {
                Assert.assertTrue(((double)orig[indexes[j]] <= val ? 1 : 0) != 0);
            }
            for (j = i + 1; j < copy.length; ++j) {
                Assert.assertTrue(((double)orig[indexes[j]] > val ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testWithQuickSortIndex_I64() {
        int i;
        long[] orig = new long[100];
        long[] copy = new long[orig.length];
        long[] sorted = new long[orig.length];
        int[] indexes = new int[orig.length];
        for (i = 0; i < orig.length; ++i) {
            orig[i] = this.rand.nextInt(6000);
            sorted[i] = orig[i];
        }
        Arrays.sort(sorted);
        for (i = 0; i < orig.length; ++i) {
            int j;
            System.arraycopy(orig, 0, copy, 0, orig.length);
            int index = QuickSelect.selectIndex(copy, i, copy.length, indexes);
            Assert.assertEquals((double)sorted[i], (double)orig[index], (double)1.0E-6);
            double val = orig[index];
            for (j = 0; j < copy.length; ++j) {
                Assert.assertEquals((long)orig[j], (long)copy[j]);
            }
            for (j = 0; j < i; ++j) {
                Assert.assertTrue(((double)orig[indexes[j]] <= val ? 1 : 0) != 0);
            }
            for (j = i + 1; j < copy.length; ++j) {
                Assert.assertTrue(((double)orig[indexes[j]] > val ? 1 : 0) != 0);
            }
        }
    }
}

