/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.sorting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import org.ddogleg.sorting.ApproximateSort_F64;
import org.ddogleg.sorting.QuickSortComparator;
import org.ddogleg.sorting.QuickSortObj_F64;
import org.ddogleg.sorting.QuickSort_F64;
import org.ddogleg.sorting.ShellSort;
import org.ddogleg.sorting.SortableParameter_F64;

public class BenchMarkSort {
    public void process(int num) {
        double[] data = BenchMarkSort.createRandom(new Random(836L), num);
        long before = System.currentTimeMillis();
        ShellSort.sort(data);
        long after = System.currentTimeMillis();
        System.out.println("Shell = " + (after - before));
        data = BenchMarkSort.createRandom(new Random(836L), num);
        QuickSort_F64 quicksort = new QuickSort_F64();
        before = System.currentTimeMillis();
        quicksort.sort(data, data.length);
        after = System.currentTimeMillis();
        System.out.println("Quicksort = " + (after - before));
        data = BenchMarkSort.createRandom(new Random(836L), num);
        int[] indexes = new int[num];
        before = System.currentTimeMillis();
        quicksort.sort(data, data.length, indexes);
        after = System.currentTimeMillis();
        System.out.println("Quicksort Indexes = " + (after - before));
        data = BenchMarkSort.createRandom(new Random(836L), num);
        ApproximateSort_F64 approx = new ApproximateSort_F64(2000);
        before = System.currentTimeMillis();
        approx.computeRange(data, 0, data.length);
        approx.sortIndex(data, 0, data.length, indexes);
        after = System.currentTimeMillis();
        System.out.println("Approx Indexes = " + (after - before));
        SortableParameter_F64[] obj = BenchMarkSort.createRandomObj(new Random(836L), num);
        QuickSortObj_F64 quicksortObj = new QuickSortObj_F64();
        before = System.currentTimeMillis();
        quicksortObj.sort(obj, obj.length);
        after = System.currentTimeMillis();
        System.out.println("QuicksortObj = " + (after - before));
        data = BenchMarkSort.createRandom(new Random(836L), num);
        before = System.currentTimeMillis();
        Arrays.sort(data);
        after = System.currentTimeMillis();
        System.out.println("Array.sort = " + (after - before));
        List<Foo> temp = BenchMarkSort.createList(new Random(836L), num);
        Foo[] tempArr = temp.toArray(new Foo[0]);
        before = System.currentTimeMillis();
        Collections.sort(temp);
        after = System.currentTimeMillis();
        System.out.println("Collections.sort = " + (after - before));
        before = System.currentTimeMillis();
        QuickSortComparator<Foo> sortComparator = new QuickSortComparator<Foo>(new FooComparator());
        sortComparator.sort((Foo[])tempArr, tempArr.length);
        after = System.currentTimeMillis();
        System.out.println("QuickSortComparator = " + (after - before));
    }

    public static List<Double> makeList(double[] data) {
        ArrayList<Double> ret = new ArrayList<Double>(data.length);
        double[] dArray = data;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            Double d = dArray[i];
            ret.add(d);
        }
        return ret;
    }

    public static double[] createRandom(Random rand, int num) {
        double[] ret = new double[num];
        for (int i = 0; i < num; ++i) {
            ret[i] = (rand.nextDouble() - 0.5) * 2000.0;
        }
        return ret;
    }

    public static SortableParameter_F64[] createRandomObj(Random rand, int num) {
        SortableParameter_F64[] ret = new SortableParameter_F64[num];
        for (int i = 0; i < num; ++i) {
            ret[i] = new SortableParameter_F64();
            ret[i].sortValue = (rand.nextDouble() - 0.5) * 2000.0;
        }
        return ret;
    }

    public static int[] createRandom_S32(Random rand, int num) {
        int[] ret = new int[num];
        for (int i = 0; i < num; ++i) {
            ret[i] = rand.nextInt(2000) - 1000;
        }
        return ret;
    }

    public static List<Foo> createList(Random rand, int num) {
        ArrayList<Foo> ret = new ArrayList<Foo>(num);
        for (int i = 0; i < num; ++i) {
            ret.add(new Foo((rand.nextDouble() - 0.5) * 2000.0));
        }
        return ret;
    }

    public static void main(String[] args) {
        BenchMarkSort bench = new BenchMarkSort();
        bench.process(3000000);
    }

    private static class FooComparator
    implements Comparator<Foo> {
        private FooComparator() {
        }

        @Override
        public int compare(Foo o1, Foo o2) {
            if (o1.value < o2.value) {
                return -1;
            }
            if (o1.value > o2.value) {
                return 1;
            }
            return 0;
        }
    }

    private static class Foo
    implements Comparable<Foo> {
        double value;

        private Foo(double value) {
            this.value = value;
        }

        @Override
        public int compareTo(Foo o) {
            if (this.value < o.value) {
                return -1;
            }
            if (this.value > o.value) {
                return 1;
            }
            return 0;
        }
    }
}

