/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.sorting;

import org.ddogleg.sorting.SortableParameter_F32;
import org.ddogleg.struct.FastQueue;
import org.ddogleg.struct.GrowQueue_I32;

public class ApproximateSort_F32 {
    FastQueue<GrowQueue_I32> histIndexes = new FastQueue<GrowQueue_I32>(GrowQueue_I32.class, true);
    FastQueue<SortableParameter_F32>[] histObjs = new FastQueue[0];
    double minValue;
    double maxValue;
    double divisor;
    int numBins;

    public ApproximateSort_F32(int numBins) {
        this.numBins = numBins;
    }

    public ApproximateSort_F32(int minValue, int maxValue, int numBins) {
        this.numBins = numBins;
        this.setRange(minValue, maxValue);
    }

    public void setRange(float minValue, float maxValue) {
        this.maxValue = maxValue;
        this.minValue = minValue;
        this.divisor = 1.00001 * (double)(maxValue - minValue) / (double)this.numBins;
        this.histIndexes.resize(this.numBins);
        if (this.histObjs.length < this.numBins) {
            this.histObjs = new FastQueue[this.numBins];
            for (int i = 0; i < this.numBins; ++i) {
                this.histObjs[i] = new FastQueue<SortableParameter_F32>(SortableParameter_F32.class, true);
            }
        }
    }

    public void computeRange(float[] input, int start, int length) {
        float max;
        if (length == 0) {
            this.divisor = 0.0;
            return;
        }
        float min = max = input[start];
        for (int i = 1; i < length; ++i) {
            float val = input[start + i];
            if (val < min) {
                min = val;
                continue;
            }
            if (!(val > max)) continue;
            max = val;
        }
        this.setRange(min, max);
    }

    public void computeRange(SortableParameter_F32[] input, int start, int length) {
        float max;
        if (length == 0) {
            this.divisor = 0.0;
            return;
        }
        float min = max = input[start].sortValue;
        for (int i = 1; i < length; ++i) {
            float val = input[start + i].sortValue;
            if (val < min) {
                min = val;
                continue;
            }
            if (!(val > max)) continue;
            max = val;
        }
        this.setRange(min, max);
    }

    public void sortIndex(float[] input, int start, int length, int[] indexes) {
        int i;
        for (i = 0; i < length; ++i) {
            indexes[i] = i;
        }
        for (i = 0; i < this.histIndexes.size; ++i) {
            this.histIndexes.get(i).reset();
        }
        for (i = 0; i < length; ++i) {
            int indexInput = i + start;
            int discretized = (int)(((double)input[indexInput] - this.minValue) / this.divisor);
            ((GrowQueue_I32[])this.histIndexes.data)[discretized].add(indexInput);
        }
        int index = 0;
        for (int i2 = 0; i2 < this.histIndexes.size; ++i2) {
            GrowQueue_I32 matches = this.histIndexes.get(i2);
            for (int j = 0; j < matches.size; ++j) {
                indexes[index++] = matches.data[j];
            }
        }
    }

    public void sortObject(SortableParameter_F32[] input, int start, int length) {
        int i;
        for (i = 0; i < this.histIndexes.size; ++i) {
            this.histObjs[i].reset();
        }
        for (i = 0; i < length; ++i) {
            int indexInput = i + start;
            SortableParameter_F32 p = input[indexInput];
            int discretized = (int)(((double)p.sortValue - this.minValue) / this.divisor);
            this.histObjs[discretized].add(p);
        }
        int index = start;
        for (int i2 = 0; i2 < this.histIndexes.size; ++i2) {
            FastQueue<SortableParameter_F32> matches = this.histObjs[i2];
            for (int j = 0; j < matches.size; ++j) {
                input[index++] = ((SortableParameter_F32[])matches.data)[j];
            }
        }
    }
}

