/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.solver;

import org.ddogleg.solver.Polynomial;
import org.junit.Assert;
import org.junit.Test;

public class TestPolynomial {
    @Test
    public void evaluate() {
        Assert.assertEquals((double)5.0, (double)Polynomial.wrap(1.0, 2.0).evaluate(2.0), (double)1.0E-8);
        Assert.assertEquals((double)5.0, (double)Polynomial.wrap(1.0, 2.0, 0.0).evaluate(2.0), (double)1.0E-8);
        Assert.assertEquals((double)10.0, (double)Polynomial.wrap(0.0, 1.0, 2.0).evaluate(2.0), (double)1.0E-8);
        Assert.assertEquals((double)0.0, (double)Polynomial.wrap(0.0).evaluate(2.0), (double)1.0E-8);
        Assert.assertEquals((double)0.0, (double)Polynomial.wrap(new double[0]).evaluate(Double.POSITIVE_INFINITY), (double)1.0E-8);
        Assert.assertEquals((double)2.0, (double)Polynomial.wrap(2.0).evaluate(Double.POSITIVE_INFINITY), (double)1.0E-8);
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)Polynomial.wrap(2.0, 3.0).evaluate(Double.POSITIVE_INFINITY), (double)1.0E-8);
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)Polynomial.wrap(2.0, 3.0, 5.0).evaluate(Double.POSITIVE_INFINITY), (double)1.0E-8);
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)Polynomial.wrap(-2.0, -3.0).evaluate(Double.POSITIVE_INFINITY), (double)1.0E-8);
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)Polynomial.wrap(-2.0, -3.0, -5.0).evaluate(Double.POSITIVE_INFINITY), (double)1.0E-8);
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)Polynomial.wrap(2.0, 3.0).evaluate(Double.NEGATIVE_INFINITY), (double)1.0E-8);
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)Polynomial.wrap(2.0, 3.0, 5.0).evaluate(Double.NEGATIVE_INFINITY), (double)1.0E-8);
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)Polynomial.wrap(-2.0, -3.0).evaluate(Double.NEGATIVE_INFINITY), (double)1.0E-8);
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)Polynomial.wrap(-2.0, -3.0, -5.0).evaluate(Double.NEGATIVE_INFINITY), (double)1.0E-8);
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)Polynomial.wrap(2.0, 3.0, 0.0, 0.0).evaluate(Double.POSITIVE_INFINITY), (double)1.0E-8);
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)Polynomial.wrap(2.0, 3.0, 0.0, 0.0).evaluate(Double.NEGATIVE_INFINITY), (double)1.0E-8);
        Polynomial p = new Polynomial(10);
        p.size = 2;
        p.c[0] = 2.0;
        p.c[1] = 3.0;
        p.c[4] = 7.0;
        Assert.assertEquals((double)8.0, (double)p.evaluate(2.0), (double)1.0E-8);
    }

    @Test
    public void computeDegree() {
        Assert.assertEquals((long)-1L, (long)Polynomial.wrap(new double[0]).computeDegree());
        Assert.assertEquals((long)-1L, (long)Polynomial.wrap(0.0).computeDegree());
        Assert.assertEquals((long)-1L, (long)Polynomial.wrap(0.0, 0.0).computeDegree());
        Assert.assertEquals((long)0L, (long)Polynomial.wrap(1.0).computeDegree());
        Assert.assertEquals((long)0L, (long)Polynomial.wrap(1.0, 0.0).computeDegree());
        Assert.assertEquals((long)0L, (long)Polynomial.wrap(1.0, 0.0, 0.0).computeDegree());
        Assert.assertEquals((long)2L, (long)Polynomial.wrap(0.0, 1.0, 2.0).computeDegree());
        Assert.assertEquals((long)3L, (long)Polynomial.wrap(0.0, 1.0, 2.0, 1.0E-15).computeDegree());
        Assert.assertEquals((long)2L, (long)Polynomial.wrap(0.0, -1.0, -2.0, 0.0).computeDegree());
    }

    @Test
    public void setTo() {
        Polynomial a = new Polynomial(10);
        Polynomial b = Polynomial.wrap(1.0, 2.0, 3.0, 4.0);
        a.setTo(b);
        Assert.assertEquals((long)b.size(), (long)a.size());
        for (int i = 0; i < a.size(); ++i) {
            Assert.assertEquals((double)a.c[i], (double)b.c[i], (double)1.0E-8);
        }
    }

    @Test
    public void resize() {
        Polynomial a = new Polynomial(10);
        Assert.assertEquals((long)10L, (long)a.size());
        a.resize(5);
        Assert.assertEquals((long)5L, (long)a.size());
        a.resize(15);
        Assert.assertEquals((long)15L, (long)a.size());
        Assert.assertEquals((long)15L, (long)a.c.length);
    }

    @Test
    public void identical() {
        Polynomial a = Polynomial.wrap(0.0, 1.0, 2.0);
        Assert.assertTrue((boolean)a.isIdentical(Polynomial.wrap(0.0, 1.0, 2.0), 1.0E-8));
        Assert.assertTrue((boolean)a.isIdentical(Polynomial.wrap(0.0, 1.0, 2.0, 0.0), 1.0E-8));
        Assert.assertTrue((boolean)a.isIdentical(Polynomial.wrap(0.0, 1.0, 2.0, 1.0E-10), 1.0E-8));
        Assert.assertTrue((boolean)Polynomial.wrap(0.0, 1.0, 1.0E-20).isIdentical(Polynomial.wrap(0.0, 1.0, 1.0E-14), 1.0E-8));
        Assert.assertTrue((boolean)Polynomial.wrap(0.0, 1.0, 1.0E-20, 0.0).isIdentical(Polynomial.wrap(0.0, 1.0, 0.0, 1.0E-14), 1.0E-8));
        Assert.assertFalse((boolean)a.isIdentical(Polynomial.wrap(0.0, 1.0, 3.0), 1.0E-8));
        Assert.assertFalse((boolean)a.isIdentical(Polynomial.wrap(0.0, 1.0, 2.00001), 1.0E-8));
        Assert.assertFalse((boolean)a.isIdentical(Polynomial.wrap(0.0, 1.0, 2.0, 3.0), 1.0E-8));
    }

    @Test
    public void truncateZeros() {
        Polynomial a = Polynomial.wrap(0.0, 1.0, 2.0, 0.0);
        Polynomial b = Polynomial.wrap(0.0, 1.0, 2.0, 1.0E-15);
        Polynomial c = Polynomial.wrap(0.0, 1.0, 2.0);
        Polynomial d = Polynomial.wrap(0.0, 1.0, 2.0, -1.0);
        a.truncateZeros(1.0E-15);
        b.truncateZeros(1.0E-15);
        c.truncateZeros(1.0E-15);
        d.truncateZeros(1.0E-15);
        Assert.assertTrue((boolean)a.isIdentical(Polynomial.wrap(0.0, 1.0, 2.0), 1.0E-8));
        Assert.assertTrue((boolean)b.isIdentical(Polynomial.wrap(0.0, 1.0, 2.0), 1.0E-8));
        Assert.assertTrue((boolean)c.isIdentical(Polynomial.wrap(0.0, 1.0, 2.0), 1.0E-8));
        Assert.assertTrue((boolean)d.isIdentical(Polynomial.wrap(0.0, 1.0, 2.0, -1.0), 1.0E-8));
    }
}

