/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.solver;

import java.util.Random;
import org.ddogleg.solver.FitQuadratic2D;
import org.junit.Assert;
import org.junit.Test;

public class TestFitQuadratic2D {
    Random rand = new Random(234L);

    @Test
    public void impulseAtZero() {
        FitQuadratic2D alg = new FitQuadratic2D();
        alg.reset();
        for (int i = -4; i <= 4; ++i) {
            for (int j = -2; j <= 2; ++j) {
                if (i == 0 && j == 0) {
                    alg.add(i, j, 5.0);
                    continue;
                }
                alg.add(j, i, 2.0);
            }
        }
        Assert.assertTrue((boolean)alg.process());
        Assert.assertEquals((double)0.0, (double)alg.getFoundX(), (double)1.0E-8);
        Assert.assertEquals((double)0.0, (double)alg.getFoundY(), (double)1.0E-8);
    }

    @Test
    public void impulseNotZero() {
        FitQuadratic2D alg = new FitQuadratic2D();
        alg.reset();
        for (int i = 0; i <= 4; ++i) {
            for (int j = -4; j <= 0; ++j) {
                if (i == 2 && j == -2) {
                    alg.add(i, j, 5.0);
                    continue;
                }
                alg.add(i, j, 2.0);
            }
        }
        Assert.assertTrue((boolean)alg.process());
        Assert.assertEquals((double)2.0, (double)alg.getFoundX(), (double)1.0E-8);
        Assert.assertEquals((double)-2.0, (double)alg.getFoundY(), (double)1.0E-8);
    }

    @Test
    public void knownCoefficients() {
        double expectedX = 2.0;
        double expectedY = -3.5;
        double a = -2.0;
        double b = -4.0;
        double c = -0.5;
        double d = -2.0 * a * expectedX - b * expectedY;
        double e = -2.0 * c * expectedY - b * expectedX;
        FitQuadratic2D alg = new FitQuadratic2D();
        alg.reset();
        for (int i = 0; i < 100; ++i) {
            double x = this.rand.nextGaussian() * 2.0;
            double y = this.rand.nextGaussian() * 4.0;
            double v = a * x * x + b * x * y + c * y * y + d * x + e * y;
            alg.add(x, y, v);
        }
        alg.process();
        Assert.assertEquals((double)expectedX, (double)alg.getFoundX(), (double)1.0E-8);
        Assert.assertEquals((double)expectedY, (double)alg.getFoundY(), (double)1.0E-8);
    }
}

