/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.wrap;

import org.ddogleg.optimization.UnconstrainedMinimization;
import org.ddogleg.optimization.functions.FunctionNtoS;
import org.ddogleg.optimization.impl.NumericalGradientForward;
import org.ddogleg.optimization.impl.TrivialFunctionNtoS;
import org.junit.Assert;
import org.junit.Test;

public abstract class GenericUnconstrainedMinimizationTests {
    public abstract UnconstrainedMinimization createAlgorithm();

    @Test
    public void basicTest() {
        double[] found;
        int i;
        TrivialFunctionNtoS residual = new TrivialFunctionNtoS();
        NumericalGradientForward jacobian = new NumericalGradientForward(residual);
        UnconstrainedMinimization alg = this.createAlgorithm();
        alg.setFunction(residual, jacobian, 0.0);
        alg.initialize(new double[]{1.0, 1.0, 1.0}, 1.0E-10, 1.0E-10);
        double[] prev = new double[]{1.0, 1.0, 1.0};
        for (i = 0; i < 200 && !alg.iterate(); ++i) {
            found = alg.getParameters();
            if (alg.isUpdated()) {
                boolean changed = false;
                for (int j = 0; j < found.length; ++j) {
                    if (found[j] == prev[j]) continue;
                    changed = true;
                }
                Assert.assertTrue((boolean)changed);
            } else {
                for (int j = 0; j < found.length; ++j) {
                    Assert.assertTrue((found[j] == prev[j] ? 1 : 0) != 0);
                }
            }
            prev = (double[])found.clone();
        }
        Assert.assertTrue((i != 200 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)alg.isConverged());
        found = alg.getParameters();
        Assert.assertEquals((double)0.0, (double)found[0], (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)found[1], (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)found[2], (double)1.0E-4);
    }

    @Test
    public void checkNumerical() {
        TrivialFunctionNtoS residual = new TrivialFunctionNtoS();
        NumericalGradientForward jacobian = new NumericalGradientForward(residual);
        UnconstrainedMinimization alg = this.createAlgorithm();
        alg.setFunction(residual, jacobian, 0.0);
        alg.initialize(new double[]{1.0, 1.0, 1.0}, 1.0E-10, 1.0E-10);
        for (int i = 0; i < 200 && !alg.iterate(); ++i) {
        }
        double[] expected = (double[])alg.getParameters().clone();
        alg.setFunction(residual, null, 0.0);
        alg.initialize(new double[]{1.0, 1.0, 1.0}, 1.0E-10, 1.0E-10);
        for (int i = 0; i < 200 && !alg.iterate(); ++i) {
        }
        double[] found = (double[])alg.getParameters().clone();
        for (int i = 0; i < found.length; ++i) {
            Assert.assertTrue((found[i] == expected[i] ? 1 : 0) != 0);
        }
    }

    @Test
    public void checkAcceptModified() {
        ModifyInputFunctions residuals = new ModifyInputFunctions();
        UnconstrainedMinimization alg = this.createAlgorithm();
        alg.setFunction(residuals, null, 0.0);
        alg.initialize(new double[]{1.0, 0.5, 9.5}, 1.0E-10, 1.0E-10);
        for (int i = 0; i < 200 && !alg.iterate(); ++i) {
        }
        double[] found = (double[])alg.getParameters().clone();
        double[] expected = new double[]{1.0, 2.0, 3.0};
        for (int i = 0; i < found.length; ++i) {
            Assert.assertTrue((found[i] == expected[i] ? 1 : 0) != 0);
        }
    }

    private class ModifyInputFunctions
    implements FunctionNtoS {
        private ModifyInputFunctions() {
        }

        @Override
        public int getNumOfInputsN() {
            return 3;
        }

        @Override
        public double process(double[] input) {
            for (int i = 0; i < input.length; ++i) {
                input[i] = 1 + i;
            }
            return 0.0;
        }
    }
}

