/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.impl;

import org.ddogleg.optimization.EvaluateLevenbergDampened;
import org.ddogleg.optimization.NonlinearResults;
import org.ddogleg.optimization.impl.LevenbergDampened;
import org.ddogleg.optimization.impl.NumericalJacobianForward;
import org.ddogleg.optimization.impl.TrivialLeastSquaresResidual;
import org.ddogleg.optimization.wrap.Individual_to_CoupledJacobian;
import org.junit.Assert;
import org.junit.Test;

public class TestLevenbergDampened {
    EvaluateLevenbergDampened evaluator = new EvaluateLevenbergDampened(false);

    @Test
    public void basicTest() {
        int i;
        double a = 2.0;
        double b = 0.1;
        LevenbergDampened alg = this.createAlg(a, b);
        alg.initialize(new double[]{1.0, 0.5});
        for (i = 0; i < 200 && !alg.iterate(); ++i) {
        }
        Assert.assertTrue((i != 200 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)alg.isConverged());
        double[] found = alg.getParameters();
        Assert.assertEquals((double)a, (double)found[0], (double)1.0E-4);
        Assert.assertEquals((double)b, (double)found[1], (double)1.0E-4);
    }

    private LevenbergDampened createAlg(double a, double b) {
        TrivialLeastSquaresResidual residual = new TrivialLeastSquaresResidual(a, b);
        NumericalJacobianForward jacobian = new NumericalJacobianForward(residual);
        LevenbergDampened alg = new LevenbergDampened(0.001);
        alg.setConvergence(1.0E-6, 1.0E-6);
        alg.setFunction(new Individual_to_CoupledJacobian(residual, jacobian));
        return alg;
    }

    @Test
    public void helicalvalley() {
        NonlinearResults results = this.evaluator.helicalValley();
        Assert.assertTrue((results.numFunction < 100 ? 1 : 0) != 0);
        Assert.assertTrue((results.numGradient < 100 ? 1 : 0) != 0);
        Assert.assertEquals((double)1.0, (double)results.x[0], (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)results.x[1], (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)results.x[2], (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)results.f, (double)1.0E-4);
    }

    @Test
    public void rosenbrock() {
        NonlinearResults results = this.evaluator.rosenbrock();
        Assert.assertTrue((results.numFunction < 100 ? 1 : 0) != 0);
        Assert.assertTrue((results.numGradient < 100 ? 1 : 0) != 0);
        Assert.assertEquals((double)1.0, (double)results.x[0], (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)results.x[1], (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)results.f, (double)1.0E-4);
    }
}

