/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.impl;

import org.ddogleg.optimization.impl.CauchyStep;
import org.ddogleg.optimization.impl.DoglegStepFtF;
import org.ejml.alg.dense.mult.VectorVectorMult;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;
import org.ejml.ops.MatrixFeatures;
import org.ejml.ops.NormOps;
import org.junit.Assert;
import org.junit.Test;

public class TestDoglegStepFtF {
    double cauchyRadius = 0.5;
    double gaussRadius = 10.0;
    double combinedRadius = 0.9;
    DenseMatrix64F J = new DenseMatrix64F(3, 2, true, 1.0, 0.5, 2.0, Math.sqrt(2.0), -2.0, 4.0);
    DenseMatrix64F x = new DenseMatrix64F(2, 1, true, 0.5, 1.5);
    DenseMatrix64F residuals = new DenseMatrix64F(3, 1, true, -1.0, -2.0, -3.0);
    DenseMatrix64F gradient = new DenseMatrix64F(2, 1);

    public TestDoglegStepFtF() {
        CommonOps.multTransA(this.J, this.residuals, this.gradient);
    }

    @Test
    public void computeStep_cauchy() {
        CauchyStep cauchy = new CauchyStep();
        WrappedDog alg = new WrappedDog();
        cauchy.init(2, 3);
        alg.init(2, 3);
        cauchy.setInputs(this.x, this.residuals, this.J, this.gradient, -1.0);
        alg.setInputs(this.x, this.residuals, this.J, this.gradient, -1.0);
        DenseMatrix64F expected = new DenseMatrix64F(2, 1);
        DenseMatrix64F found = new DenseMatrix64F(2, 1);
        cauchy.computeStep(this.cauchyRadius, expected);
        alg.computeStep(this.cauchyRadius, found);
        Assert.assertTrue((boolean)cauchy.isMaxStep());
        Assert.assertTrue((boolean)alg.isMaxStep());
        Assert.assertTrue((boolean)alg.calledCauchy);
        Assert.assertTrue((boolean)MatrixFeatures.isIdentical(expected, found, 1.0E-8));
    }

    @Test
    public void computeStep_GaussNewton() {
        DoglegStepFtF alg = new DoglegStepFtF();
        alg.init(2, 3);
        alg.setInputs(this.x, this.residuals, this.J, this.gradient, -1.0);
        DenseMatrix64F step = new DenseMatrix64F(2, 1);
        alg.computeStep(this.gaussRadius, step);
        Assert.assertFalse((boolean)alg.isMaxStep());
        double a = TestDoglegStepFtF.cost(this.residuals, this.J, step, 0.0, 0.0);
        double b = TestDoglegStepFtF.cost(this.residuals, this.J, step, 0.01, 0.0);
        double c = TestDoglegStepFtF.cost(this.residuals, this.J, step, -0.01, 0.0);
        double d = TestDoglegStepFtF.cost(this.residuals, this.J, step, 0.0, 0.01);
        double e = TestDoglegStepFtF.cost(this.residuals, this.J, step, 0.0, -0.01);
        Assert.assertTrue((a < b ? 1 : 0) != 0);
        Assert.assertTrue((a < c ? 1 : 0) != 0);
        Assert.assertTrue((a < d ? 1 : 0) != 0);
        Assert.assertTrue((a < e ? 1 : 0) != 0);
    }

    @Test
    public void computeStep_Hybrid() {
        WrappedDog alg = new WrappedDog();
        alg.init(2, 3);
        alg.setInputs(this.x, this.residuals, this.J, this.gradient, -1.0);
        DenseMatrix64F step = new DenseMatrix64F(2, 1);
        alg.computeStep(this.combinedRadius, step);
        Assert.assertTrue((boolean)alg.calledCombined);
        Assert.assertTrue((boolean)alg.isMaxStep());
        double r = NormOps.normF(step);
        Assert.assertEquals((double)this.combinedRadius, (double)r, (double)1.0E-8);
    }

    @Test
    public void predict_cauchy() {
        this.checkPredictedCost(this.cauchyRadius, true, false);
    }

    @Test
    public void predict_GaussNewton() {
        this.checkPredictedCost(this.gaussRadius, false, false);
    }

    @Test
    public void predict_Hybrid() {
        this.checkPredictedCost(this.combinedRadius, false, true);
    }

    private void checkPredictedCost(double radius, boolean calledCauchy, boolean calledCombined) {
        double fx = VectorVectorMult.innerProd(this.residuals, this.residuals) * 0.5;
        WrappedDog alg = new WrappedDog();
        alg.init(2, 3);
        alg.setInputs(this.x, this.residuals, this.J, this.gradient, fx);
        DenseMatrix64F step = new DenseMatrix64F(2, 1);
        alg.computeStep(radius, step);
        Assert.assertTrue((alg.calledCauchy == calledCauchy ? 1 : 0) != 0);
        Assert.assertTrue((alg.calledCombined == calledCombined ? 1 : 0) != 0);
        double expected = fx - TestDoglegStepFtF.cost(this.residuals, this.J, step, 0.0, 0.0);
        Assert.assertEquals((double)expected, (double)alg.predictedReduction(), (double)1.0E-8);
    }

    public static double cost(DenseMatrix64F residuals, DenseMatrix64F J, DenseMatrix64F h, double ... delta) {
        h = h.copy();
        for (int i = 0; i < h.numRows; ++i) {
            int n = i;
            h.data[n] = h.data[n] + delta[i];
        }
        DenseMatrix64F B = new DenseMatrix64F(J.numCols, J.numCols);
        CommonOps.multTransA(J, J, B);
        double left = VectorVectorMult.innerProd(residuals, residuals);
        double middle = VectorVectorMult.innerProdA(residuals, J, h);
        double right = VectorVectorMult.innerProdA(h, B, h);
        return 0.5 * left + middle + 0.5 * right;
    }

    protected static class WrappedDog
    extends DoglegStepFtF {
        boolean calledCombined = false;
        boolean calledCauchy = false;

        protected WrappedDog() {
        }

        @Override
        protected void cauchyStep(double regionRadius, DenseMatrix64F step) {
            super.cauchyStep(regionRadius, step);
            this.calledCauchy = true;
        }

        @Override
        protected void combinedStep(double regionRadius, DenseMatrix64F step) {
            super.combinedStep(regionRadius, step);
            this.calledCombined = true;
        }
    }
}

