/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.impl;

import org.ddogleg.optimization.functions.FunctionStoS;
import org.ejml.UtilEjml;

public class NumericalDerivativeForward
implements FunctionStoS {
    private FunctionStoS function;
    private double differenceScale;

    public NumericalDerivativeForward(FunctionStoS function, double differenceScale) {
        this.function = function;
        this.differenceScale = differenceScale;
    }

    public NumericalDerivativeForward(FunctionStoS function) {
        this(function, Math.sqrt(UtilEjml.EPS));
    }

    @Override
    public double process(double x) {
        double valueOrig = this.function.process(x);
        double h = x != 0.0 ? this.differenceScale * Math.abs(x) : this.differenceScale;
        double temp = x + h;
        h = temp - x;
        double perturbed = this.function.process(temp);
        return (perturbed - valueOrig) / h;
    }
}

