/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.funcs;

import org.ddogleg.optimization.funcs.EvalFuncLeastSquares;
import org.ddogleg.optimization.functions.FunctionNtoM;
import org.ddogleg.optimization.functions.FunctionNtoMxN;

public class EvalFuncVariablyDimensioned
implements EvalFuncLeastSquares {
    int N;

    public EvalFuncVariablyDimensioned(int n) {
        this.N = n;
    }

    @Override
    public FunctionNtoM getFunction() {
        return new Func();
    }

    @Override
    public FunctionNtoMxN getJacobian() {
        return null;
    }

    @Override
    public double[] getInitial() {
        double[] x = new double[this.N];
        for (int i = 0; i < this.N; ++i) {
            x[i] = 1.0 - (double)i / (double)this.N;
        }
        return x;
    }

    @Override
    public double[] getOptimal() {
        double[] x = new double[this.N];
        for (int i = 0; i < this.N; ++i) {
            x[i] = 1.0;
        }
        return x;
    }

    public class Func
    implements FunctionNtoM {
        @Override
        public int getNumOfInputsN() {
            return EvalFuncVariablyDimensioned.this.N;
        }

        @Override
        public int getNumOfOutputsM() {
            return EvalFuncVariablyDimensioned.this.N + 2;
        }

        @Override
        public void process(double[] input, double[] output) {
            for (int i = 0; i < EvalFuncVariablyDimensioned.this.N; ++i) {
                output[i] = input[i] - 1.0;
            }
            double sum = 0.0;
            for (int i = 0; i < EvalFuncVariablyDimensioned.this.N; ++i) {
                sum += (double)(i + 1) * (input[i] - 1.0);
            }
            output[EvalFuncVariablyDimensioned.this.N] = sum;
            output[EvalFuncVariablyDimensioned.this.N + 1] = sum * sum;
        }
    }
}

