/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.funcs;

import org.ddogleg.optimization.funcs.EvalFuncLeastSquares;
import org.ddogleg.optimization.functions.FunctionNtoM;
import org.ddogleg.optimization.functions.FunctionNtoMxN;

public class EvalFuncBadlyScaledBrown
implements EvalFuncLeastSquares {
    @Override
    public FunctionNtoM getFunction() {
        return new Func();
    }

    @Override
    public FunctionNtoMxN getJacobian() {
        return new Deriv();
    }

    @Override
    public double[] getInitial() {
        return new double[]{1.0, 1.0};
    }

    @Override
    public double[] getOptimal() {
        return new double[]{1000000.0, 2.0E-6};
    }

    public class Deriv
    implements FunctionNtoMxN {
        @Override
        public int getNumOfInputsN() {
            return 2;
        }

        @Override
        public int getNumOfOutputsM() {
            return 3;
        }

        @Override
        public void process(double[] input, double[] output) {
            double x1 = input[0];
            double x2 = input[1];
            output[0] = 1.0;
            output[1] = 0.0;
            output[2] = 0.0;
            output[3] = 1.0;
            output[4] = x2;
            output[5] = x1;
        }
    }

    public class Func
    implements FunctionNtoM {
        @Override
        public int getNumOfInputsN() {
            return 2;
        }

        @Override
        public int getNumOfOutputsM() {
            return 3;
        }

        @Override
        public void process(double[] input, double[] output) {
            double x1 = input[0];
            double x2 = input[1];
            output[0] = x1 - 1000000.0;
            output[1] = x2 - 2.0E-6;
            output[2] = x1 * x2 - 2.0;
        }
    }
}

