/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization;

import org.ddogleg.optimization.DerivativeChecker;
import org.ddogleg.optimization.functions.FunctionNtoN;
import org.ddogleg.optimization.functions.FunctionNtoS;
import org.junit.Assert;
import org.junit.Test;

public class TestDerivativeChecker {
    @Test
    public void gradient() {
        SimpleS f = new SimpleS();
        SimpleGradient g = new SimpleGradient();
        Assert.assertTrue((boolean)DerivativeChecker.gradient(f, g, new double[]{2.0, 4.5}, 1.0E-5));
    }

    private static class SimpleGradient
    implements FunctionNtoN {
        private SimpleGradient() {
        }

        @Override
        public int getN() {
            return 2;
        }

        @Override
        public void process(double[] input, double[] output) {
            double x = input[0];
            double y = input[1];
            output[0] = 4.0 * x + 6.7 * y;
            output[1] = y + 6.7 * x;
        }
    }

    private static class SimpleS
    implements FunctionNtoS {
        private SimpleS() {
        }

        @Override
        public int getNumOfInputsN() {
            return 2;
        }

        @Override
        public double process(double[] input) {
            double x = input[0];
            double y = input[1];
            return 2.0 * x * x + 0.5 * y * y + 6.7 * x * y;
        }
    }
}

