/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization;

import org.ddogleg.optimization.UnconstrainedLeastSquares;
import org.ddogleg.optimization.UnconstrainedLeastSquaresEvaluator;
import org.ddogleg.optimization.impl.LevenbergMarquardtDampened;
import org.ddogleg.optimization.wrap.LevenbergDampened_to_UnconstrainedLeastSquares;
import org.ejml.data.DenseMatrix64F;
import org.ejml.factory.LinearSolverFactory;
import org.ejml.interfaces.linsol.LinearSolver;

public class EvaluateLevenbergMarquardtDampened
extends UnconstrainedLeastSquaresEvaluator {
    boolean robust = true;
    double dampInit = 0.001;

    public EvaluateLevenbergMarquardtDampened(boolean verbose) {
        super(verbose, false);
    }

    @Override
    protected UnconstrainedLeastSquares createSearch(double minimumValue) {
        LinearSolver<DenseMatrix64F> solver = this.robust ? LinearSolverFactory.pseudoInverse(true) : LinearSolverFactory.symmPosDef(10);
        LevenbergMarquardtDampened alg = new LevenbergMarquardtDampened(solver, this.dampInit);
        return new LevenbergDampened_to_UnconstrainedLeastSquares(alg);
    }

    public static void main(String[] args) {
        EvaluateLevenbergMarquardtDampened eval = new EvaluateLevenbergMarquardtDampened(false);
        System.out.println("Powell              ----------------");
        eval.powell();
        System.out.println("Helical Valley      ----------------");
        eval.helicalValley();
        System.out.println("Rosenbrock          ----------------");
        eval.rosenbrock();
        System.out.println("Rosenbrock Mod      ----------------");
        eval.rosenbrockMod(Math.sqrt(2000000.0));
        System.out.println("variably            ----------------");
        eval.variably();
        System.out.println("trigonometric       ----------------");
        eval.trigonometric();
        System.out.println("Bady Scaled Brown   ----------------");
        eval.badlyScaledBrown();
    }
}

