/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization;

import org.ddogleg.optimization.UnconstrainedLeastSquares;
import org.ddogleg.optimization.UnconstrainedLeastSquaresEvaluator;
import org.ddogleg.optimization.impl.LevenbergDampened;
import org.ddogleg.optimization.wrap.LevenbergDampened_to_UnconstrainedLeastSquares;

public class EvaluateLevenbergDampened
extends UnconstrainedLeastSquaresEvaluator {
    double dampInit = 0.001;

    public EvaluateLevenbergDampened(boolean verbose) {
        super(verbose, false);
    }

    @Override
    protected UnconstrainedLeastSquares createSearch(double minimumValue) {
        LevenbergDampened alg = new LevenbergDampened(this.dampInit);
        return new LevenbergDampened_to_UnconstrainedLeastSquares(alg);
    }

    public static void main(String[] args) {
        EvaluateLevenbergDampened eval = new EvaluateLevenbergDampened(false);
        System.out.println("Powell              ----------------");
        eval.powell();
        System.out.println("Helical Valley      ----------------");
        eval.helicalValley();
        System.out.println("Rosenbrock          ----------------");
        eval.rosenbrock();
        System.out.println("Rosenbrock Mod      ----------------");
        eval.rosenbrockMod(Math.sqrt(2000000.0));
        System.out.println("variably            ----------------");
        eval.variably();
        System.out.println("trigonometric       ----------------");
        eval.trigonometric();
        System.out.println("Bady Scaled Brown   ----------------");
        eval.badlyScaledBrown();
    }
}

