/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.nn.alg;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.ddogleg.nn.alg.KdTree;
import org.ddogleg.nn.alg.KdTreeResult;
import org.ddogleg.nn.alg.KdTreeSearchN;
import org.ddogleg.nn.alg.StandardKdTreeSearch1Tests;
import org.ddogleg.sorting.QuickSelect;
import org.ddogleg.struct.FastQueue;
import org.ddogleg.struct.GrowQueue_F64;
import org.ddogleg.struct.GrowQueue_I32;
import org.junit.Assert;
import org.junit.Test;

public abstract class StandardKdTreeSearchNTests {
    FastQueue<KdTreeResult> found = new FastQueue<KdTreeResult>(KdTreeResult.class, true);
    Random rand = new Random(234L);

    public abstract KdTreeSearchN createAlg();

    @Test
    public void findClosest_basic_1() {
        KdTreeSearchN alg = this.createAlg();
        KdTree tree = StandardKdTreeSearch1Tests.createTreeA();
        alg.setTree(tree);
        alg.setMaxDistance(Double.MAX_VALUE);
        this.found.reset();
        alg.findNeighbor(new double[]{11.0, 8.0}, 1, this.found);
        Assert.assertEquals((long)1L, (long)this.found.size);
        Assert.assertTrue((((KdTreeResult[])this.found.data)[0].node == tree.root.right.right ? 1 : 0) != 0);
        this.found.reset();
        alg.findNeighbor(new double[]{1.001, 1.99999}, 1, this.found);
        Assert.assertTrue((((KdTreeResult[])this.found.data)[0].node == tree.root ? 1 : 0) != 0);
        this.found.reset();
        alg.findNeighbor(new double[]{2.0, 0.8}, 1, this.found);
        Assert.assertTrue((((KdTreeResult[])this.found.data)[0].node == tree.root.left.right ? 1 : 0) != 0);
        this.found.reset();
        alg.findNeighbor(new double[]{-10000.0, 0.5}, 1, this.found);
        Assert.assertTrue((((KdTreeResult[])this.found.data)[0].node == tree.root.left.left ? 1 : 0) != 0);
    }

    @Test
    public void findClosest_nullLeaf() {
        KdTreeSearchN alg = this.createAlg();
        KdTree tree = StandardKdTreeSearch1Tests.createTreeWithNull();
        alg.setTree(tree);
        alg.setMaxDistance(Double.MAX_VALUE);
        this.found.reset();
        alg.findNeighbor(new double[]{2.0, 3.0}, 1, this.found);
        Assert.assertTrue((this.found.get((int)0).node == tree.root ? 1 : 0) != 0);
    }

    @Test
    public void randomTests() {
        KdTreeSearchN alg = this.createAlg();
        KdTree tree = StandardKdTreeSearch1Tests.createTreeA();
        alg.setTree(tree);
        ArrayList<double[]> data = new ArrayList<double[]>();
        StandardKdTreeSearchNTests.flattenTree(tree.root, data);
        for (int i = 0; i < 100; ++i) {
            int searchN = this.rand.nextInt(data.size() + 5) + 1;
            double[] target = (double[])data.get(this.rand.nextInt(data.size()));
            double maxDistance = this.rand.nextDouble() * 10.0;
            List<double[]> expected = StandardKdTreeSearchNTests.findNeighbors(data, target, maxDistance, searchN);
            this.found.reset();
            alg.setMaxDistance(maxDistance);
            alg.findNeighbor(target, searchN, this.found);
            Assert.assertEquals((long)expected.size(), (long)this.found.size);
            for (int j = 0; j < expected.size(); ++j) {
                this.checkContains(expected.get(j));
            }
        }
    }

    @Test
    public void findClosest_empty() {
        KdTreeSearchN alg = this.createAlg();
        alg.setTree(new KdTree(2));
        this.found.reset();
        alg.findNeighbor(new double[]{11.0, 8.0}, 2, this.found);
        Assert.assertEquals((long)0L, (long)this.found.size());
    }

    @Test
    public void findClosest_leaf() {
        KdTree tree = new KdTree(2);
        tree.root = new KdTree.Node(new double[]{1.0, 2.0}, null);
        KdTreeSearchN alg = this.createAlg();
        alg.setTree(tree);
        this.found.reset();
        alg.findNeighbor(new double[]{11.0, 8.0}, 2, this.found);
        Assert.assertEquals((long)1L, (long)this.found.size);
        Assert.assertTrue((((KdTreeResult[])this.found.data)[0].node == tree.root ? 1 : 0) != 0);
        this.found.reset();
        alg.findNeighbor(new double[]{2.0, 5.0}, 2, this.found);
        Assert.assertEquals((long)1L, (long)this.found.size);
        Assert.assertTrue((((KdTreeResult[])this.found.data)[0].node == tree.root ? 1 : 0) != 0);
    }

    @Test
    public void findClosest_maxDistance() {
        KdTree tree = new KdTree(2);
        tree.root = new KdTree.Node(new double[]{1.0, 2.0}, null);
        KdTreeSearchN alg = this.createAlg();
        alg.setTree(tree);
        alg.setMaxDistance(2.0);
        this.found.reset();
        alg.findNeighbor(new double[]{11.0, 8.0}, 1, this.found);
        Assert.assertEquals((long)0L, (long)this.found.size);
        this.found.reset();
        alg.findNeighbor(new double[]{1.0, 1.5}, 1, this.found);
        Assert.assertEquals((long)1L, (long)this.found.size);
        Assert.assertTrue((((KdTreeResult[])this.found.data)[0].node == tree.root ? 1 : 0) != 0);
    }

    @Test
    public void checkDistance() {
        KdTreeSearchN alg = this.createAlg();
        KdTree tree = StandardKdTreeSearch1Tests.createTreeA();
        alg.setTree(tree);
        alg.setMaxDistance(Double.MAX_VALUE);
        double[] pt = new double[]{11.5, 8.2};
        this.found.reset();
        alg.findNeighbor(pt, 1, this.found);
        Assert.assertEquals((long)1L, (long)this.found.size);
        double d0 = this.found.get((int)0).node.point[0] - pt[0];
        double d1 = this.found.get((int)0).node.point[1] - pt[1];
        Assert.assertEquals((double)(d0 * d0 + d1 * d1), (double)this.found.get((int)0).distance, (double)1.0E-8);
    }

    @Test
    public void checkDuplicates() {
        KdTreeSearchN alg = this.createAlg();
        KdTree tree = StandardKdTreeSearchNTests.createTreeDuplicates();
        alg.setTree(tree);
        alg.setMaxDistance(Double.MAX_VALUE);
        double[] pt = new double[]{1.0, 2.0};
        this.found.reset();
        alg.findNeighbor(pt, 3, this.found);
        Assert.assertEquals((long)3L, (long)this.found.size);
        for (int i = 0; i < 3; ++i) {
            double[] a = this.found.get((int)i).node.point;
            for (int j = i + 1; j < 3; ++j) {
                Assert.assertTrue((this.found.get((int)j).node.point != a ? 1 : 0) != 0);
            }
        }
    }

    private void checkContains(KdTree.Node node) {
        for (int i = 0; i < this.found.size; ++i) {
            if (((KdTreeResult[])this.found.data)[i].node != node) continue;
            return;
        }
        Assert.fail((String)"can't find");
    }

    private void checkContains(double[] d) {
        for (int i = 0; i < this.found.size; ++i) {
            boolean identical = true;
            double[] f = ((KdTreeResult[])this.found.data)[i].node.point;
            for (int j = 0; j < d.length; ++j) {
                if (d[j] == f[j]) continue;
                identical = false;
                break;
            }
            if (!identical) continue;
            return;
        }
        Assert.fail((String)"can't find");
    }

    private static void flattenTree(KdTree.Node n, List<double[]> data) {
        data.add(n.point);
        if (!n.isLeaf()) {
            StandardKdTreeSearchNTests.flattenTree(n.left, data);
            StandardKdTreeSearchNTests.flattenTree(n.right, data);
        }
    }

    private static List<double[]> findNeighbors(List<double[]> data, double[] target, double maxDistance, int maxN) {
        int i;
        ArrayList<double[]> ret = new ArrayList<double[]>();
        ArrayList<double[]> found = new ArrayList<double[]>();
        GrowQueue_F64 distances = new GrowQueue_F64();
        GrowQueue_I32 indexes = new GrowQueue_I32();
        for (i = 0; i < data.size(); ++i) {
            double dy;
            double[] d = data.get(i);
            double dx = d[0] - target[0];
            double dist = dx * dx + (dy = d[1] - target[1]) * dy;
            if (!(dist <= maxDistance)) continue;
            distances.add(dist);
            found.add(d);
        }
        indexes.resize(distances.size);
        maxN = Math.min(maxN, distances.size);
        QuickSelect.selectIndex(distances.data, maxN, distances.size, indexes.data);
        for (i = 0; i < maxN; ++i) {
            ret.add((double[])found.get(indexes.data[i]));
        }
        return ret;
    }

    public static KdTree createTreeDuplicates() {
        KdTree tree = new KdTree(2);
        tree.root = new KdTree.Node(new double[]{1.0, 2.0}, null);
        tree.root.split = 1;
        tree.root.left = new KdTree.Node(new double[]{1.0, 2.0}, null);
        tree.root.left.split = 0;
        tree.root.left.left = new KdTree.Node(new double[]{1.0, 2.0}, null);
        tree.root.left.left.split = -1;
        tree.root.left.right = null;
        tree.root.right = new KdTree.Node(new double[]{1.0, 2.0}, null);
        tree.root.right.split = -1;
        return tree;
    }
}

