/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.nn;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.ddogleg.Performer;
import org.ddogleg.ProfileOperation;
import org.ddogleg.nn.FactoryNearestNeighbor;
import org.ddogleg.nn.NearestNeighbor;
import org.ddogleg.nn.NnData;

public class BenchmarkNearestNeighbor {
    int dimen;
    List<double[]> cloud;
    List<double[]> searchSet;
    double maxDistance;
    NnData result = new NnData();

    public List<Performer> createAlg() {
        ArrayList<Performer> ret = new ArrayList<Performer>();
        ret.add(new SetAndSearch(FactoryNearestNeighbor.exhaustive(), "Exhaustive"));
        ret.add(new SetAndSearch(FactoryNearestNeighbor.kdtree(), "kdtree"));
        ret.add(new SetAndSearch(FactoryNearestNeighbor.kdtree(1000), "kdtree P"));
        ret.add(new SetAndSearch(FactoryNearestNeighbor.kdRandomForest(200, 20, 5, 23423432L), "K-D Random Forest"));
        ret.add(new SetAndSearch(FactoryNearestNeighbor.vptree(-559038737L), "VP-Tree"));
        return ret;
    }

    public void evaluateDataSet(int dimen, int cloudSize, int searchSize) {
        Random rand = new Random(234L);
        this.dimen = dimen;
        this.maxDistance = 10.0;
        this.searchSet = BenchmarkNearestNeighbor.createData(rand, searchSize, dimen);
        System.out.println("Uniform data");
        this.cloud = BenchmarkNearestNeighbor.createData(rand, cloudSize, dimen);
        System.out.println("K = " + dimen + "  cloud = " + cloudSize + "  search = " + searchSize);
        for (Performer alg : this.createAlg()) {
            ProfileOperation.printOpsPerSec(alg, 100L);
        }
        System.out.println();
        System.out.println("Linear data");
        this.cloud = BenchmarkNearestNeighbor.createLinearData(rand, cloudSize, dimen);
        System.out.println("K = " + dimen + "  cloud = " + cloudSize + "  search = " + searchSize);
        for (Performer alg : this.createAlg()) {
            ProfileOperation.printOpsPerSec(alg, 100L);
        }
    }

    public static List<double[]> createData(Random rand, int size, int k) {
        ArrayList<double[]> ret = new ArrayList<double[]>();
        for (int i = 0; i < size; ++i) {
            double[] d = new double[k];
            for (int j = 0; j < k; ++j) {
                d[j] = rand.nextDouble() * 3.0;
            }
            ret.add(d);
        }
        return ret;
    }

    public static List<double[]> createLinearData(Random rand, int size, int k) {
        ArrayList<double[]> ret = new ArrayList<double[]>();
        double[] v = new double[k];
        for (int j = 0; j < k; ++j) {
            v[j] = (rand.nextDouble() - 0.5) * 2.0;
        }
        for (int i = 0; i < size; ++i) {
            double[] d = new double[k];
            double l = rand.nextDouble() * 3.0;
            for (int j = 0; j < k; ++j) {
                d[j] = v[j] * l;
            }
            ret.add(d);
        }
        return ret;
    }

    public static void main(String[] args) {
        BenchmarkNearestNeighbor app = new BenchmarkNearestNeighbor();
        app.evaluateDataSet(60, 10000, 10000);
    }

    public class SetAndSearch
    implements Performer {
        NearestNeighbor alg;
        String name;

        public SetAndSearch(NearestNeighbor alg, String name) {
            this.alg = alg;
            this.name = name;
        }

        @Override
        public void process() {
            this.alg.init(BenchmarkNearestNeighbor.this.dimen);
            this.alg.setPoints(BenchmarkNearestNeighbor.this.cloud, null);
            for (double[] p : BenchmarkNearestNeighbor.this.searchSet) {
                this.alg.findNearest(p, BenchmarkNearestNeighbor.this.maxDistance, BenchmarkNearestNeighbor.this.result);
            }
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

