/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.graph;

import org.ddogleg.graph.Edge;
import org.ddogleg.graph.GraphDataManager;
import org.ddogleg.graph.Node;
import org.junit.Assert;
import org.junit.Test;

public class TestGraphDataManager {
    @Test
    public void reset() {
        GraphDataManager alg = new GraphDataManager();
        Node n = alg.createNode();
        n.data = 1;
        n.edges.grow();
        Edge e = alg.createEdge();
        e.data = 1;
        e.dest = n;
        alg.reset();
        Assert.assertEquals((long)0L, (long)alg.usedEdges.size());
        Assert.assertEquals((long)1L, (long)alg.unusedEdges.size());
        Assert.assertEquals((long)0L, (long)alg.usedNodes.size());
        Assert.assertEquals((long)1L, (long)alg.unusedNodes.size());
        Assert.assertTrue((((Edge)alg.unusedEdges.get((int)0)).data != null ? 1 : 0) != 0);
        Assert.assertTrue((((Edge)alg.unusedEdges.get((int)0)).dest != null ? 1 : 0) != 0);
        Assert.assertTrue((((Node)alg.unusedNodes.get((int)0)).data != null ? 1 : 0) != 0);
        Assert.assertTrue((((Node)alg.unusedNodes.get((int)0)).edges.size != 0 ? 1 : 0) != 0);
    }

    @Test
    public void resetHard() {
        GraphDataManager alg = new GraphDataManager();
        Node n = alg.createNode();
        n.data = 1;
        n.edges.grow();
        Edge e = alg.createEdge();
        e.data = 1;
        e.dest = n;
        alg.resetHard();
        Assert.assertEquals((long)0L, (long)alg.usedEdges.size());
        Assert.assertEquals((long)1L, (long)alg.unusedEdges.size());
        Assert.assertEquals((long)0L, (long)alg.usedNodes.size());
        Assert.assertEquals((long)1L, (long)alg.unusedNodes.size());
        Assert.assertTrue((((Edge)alg.unusedEdges.get((int)0)).data == null ? 1 : 0) != 0);
        Assert.assertTrue((((Edge)alg.unusedEdges.get((int)0)).dest == null ? 1 : 0) != 0);
        Assert.assertTrue((((Node)alg.unusedNodes.get((int)0)).data == null ? 1 : 0) != 0);
        Assert.assertTrue((((Node)alg.unusedNodes.get((int)0)).edges.size == 0 ? 1 : 0) != 0);
    }

    @Test
    public void createEdge() {
        GraphDataManager alg = new GraphDataManager();
        Edge e = alg.createEdge();
        Assert.assertEquals((long)1L, (long)alg.usedEdges.size());
        Assert.assertEquals((long)0L, (long)alg.unusedEdges.size());
        alg.reset();
        Assert.assertTrue((e == alg.createEdge() ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)alg.usedEdges.size());
        Assert.assertEquals((long)0L, (long)alg.unusedEdges.size());
    }

    @Test
    public void recycleEdge() {
        GraphDataManager alg = new GraphDataManager();
        Edge e = alg.createEdge();
        Assert.assertEquals((long)1L, (long)alg.usedEdges.size());
        Assert.assertEquals((long)0L, (long)alg.unusedEdges.size());
        alg.recycleEdge(e);
        Assert.assertEquals((long)0L, (long)alg.usedEdges.size());
        Assert.assertEquals((long)1L, (long)alg.unusedEdges.size());
    }

    @Test
    public void createNode() {
        GraphDataManager alg = new GraphDataManager();
        Node e = alg.createNode();
        Assert.assertEquals((long)1L, (long)alg.usedNodes.size());
        Assert.assertEquals((long)0L, (long)alg.unusedNodes.size());
        alg.recycleNode(e);
        Assert.assertEquals((long)0L, (long)alg.usedNodes.size());
        Assert.assertEquals((long)1L, (long)alg.unusedNodes.size());
    }

    @Test
    public void recycleNode() {
        GraphDataManager alg = new GraphDataManager();
        Node n = alg.createNode();
        Assert.assertEquals((long)1L, (long)alg.usedNodes.size());
        Assert.assertEquals((long)0L, (long)alg.unusedNodes.size());
        alg.reset();
        Assert.assertTrue((n == alg.createNode() ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)alg.usedNodes.size());
        Assert.assertEquals((long)0L, (long)alg.unusedNodes.size());
    }
}

