/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.fitting.modelset;

import java.util.ArrayList;
import java.util.List;
import org.ddogleg.fitting.modelset.DistanceFromModel;
import org.ddogleg.fitting.modelset.DoNothingModelFitter;
import org.ddogleg.fitting.modelset.DoubleArrayManager;
import org.ddogleg.fitting.modelset.GenericModelMatcherTests;
import org.ddogleg.fitting.modelset.ModelFitter;
import org.ddogleg.fitting.modelset.ModelGenerator;
import org.ddogleg.fitting.modelset.ModelManager;
import org.ddogleg.fitting.modelset.ModelMatcher;
import org.ddogleg.fitting.modelset.ModelMatcherMulti;
import org.ddogleg.fitting.modelset.RandomDistanceModel;
import org.junit.Assert;
import org.junit.Test;

public abstract class GenericModelMatcherMultiTests
extends GenericModelMatcherTests {
    @Override
    public ModelMatcher<double[], Double> createModelMatcher(ModelManager<double[]> manager, DistanceFromModel<double[], Double> distance, ModelGenerator<double[], Double> generator, ModelFitter<double[], Double> fitter, int minPoints, double fitThreshold) {
        ArrayList<ModelInfo> models = new ArrayList<ModelInfo>();
        ModelInfo model0 = new ModelInfo();
        model0.manager = manager;
        model0.distance = distance;
        model0.generator = generator;
        model0.minPoints = minPoints;
        model0.fitThreshold = fitThreshold;
        model0.fitter = fitter;
        models.add(model0);
        return this.createModelMatcher(models);
    }

    @Test
    public void checkSelectModel() {
        ArrayList<ModelInfo> models = new ArrayList<ModelInfo>();
        ModelInfo model0 = new ModelInfo();
        model0.manager = new DoubleArrayManager(1);
        model0.distance = new RandomDistanceModel(5.0, 0.3);
        model0.generator = new DoNothingModelFitter(2);
        model0.minPoints = -1;
        model0.fitThreshold = 0.1;
        ModelInfo model1 = new ModelInfo();
        model1.manager = new DoubleArrayManager(1);
        model1.distance = new RandomDistanceModel(0.0, 0.05);
        model1.generator = new DoNothingModelFitter(3);
        model1.minPoints = -1;
        model1.fitThreshold = 0.1;
        models.add(model0);
        models.add(model1);
        ArrayList<Double> points = new ArrayList<Double>();
        for (int i = 0; i < 100; ++i) {
            points.add(0.1 + (double)i);
        }
        ModelMatcherMulti<Double> alg = this.createModelMatcher(models);
        Assert.assertTrue((boolean)alg.process(points));
        Assert.assertEquals((long)1L, (long)alg.getModelIndex());
    }

    public abstract ModelMatcherMulti<Double> createModelMatcher(List<ModelInfo> var1);

    public static class ModelInfo {
        public ModelManager<double[]> manager;
        public DistanceFromModel<double[], Double> distance;
        public ModelGenerator<double[], Double> generator;
        public ModelFitter<double[], Double> fitter;
        public int minPoints;
        public double fitThreshold;
    }
}

