/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.example;

import java.util.List;
import org.ddogleg.example.Line2D;
import org.ddogleg.example.Point2D;
import org.ddogleg.fitting.modelset.DistanceFromModel;

public class DistanceFromLine
implements DistanceFromModel<Line2D, Point2D> {
    double x0;
    double y0;
    double slopeX;
    double slopeY;

    @Override
    public void setModel(Line2D param) {
        this.x0 = param.x;
        this.y0 = param.y;
        this.slopeX = -this.y0;
        this.slopeY = this.x0;
    }

    @Override
    public double computeDistance(Point2D p) {
        double t = this.slopeX * (p.x - this.x0) + this.slopeY * (p.y - this.y0);
        double closestX = this.x0 + (t /= this.slopeX * this.slopeX + this.slopeY * this.slopeY) * this.slopeX;
        double closestY = this.y0 + t * this.slopeY;
        double dx = p.x - closestX;
        double dy = p.y - closestY;
        return Math.sqrt(dx * dx + dy * dy);
    }

    @Override
    public void computeDistance(List<Point2D> obs, double[] distance) {
        for (int i = 0; i < obs.size(); ++i) {
            distance[i] = this.computeDistance(obs.get(i));
        }
    }
}

