/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.combinatorics;

import java.util.ArrayList;
import java.util.List;
import org.ddogleg.combinatorics.Combinations;
import org.junit.Assert;
import org.junit.Test;

public class TestCombinations {
    @Test
    public void next_1_1() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(1);
        Combinations alg = new Combinations(list, 1);
        Assert.assertEquals((long)1L, (long)((Integer)alg.get(0)).intValue());
        Assert.assertFalse((boolean)alg.next());
    }

    @Test
    public void next_1_2() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(1);
        list.add(2);
        Combinations alg = new Combinations(list, 1);
        Assert.assertEquals((long)1L, (long)((Integer)alg.get(0)).intValue());
        Assert.assertTrue((boolean)alg.next());
        Assert.assertEquals((long)2L, (long)((Integer)alg.get(0)).intValue());
        Assert.assertFalse((boolean)alg.next());
    }

    @Test
    public void next_2_2() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(1);
        list.add(2);
        Combinations alg = new Combinations(list, 2);
        Assert.assertEquals((long)1L, (long)((Integer)alg.get(0)).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)alg.get(1)).intValue());
        Assert.assertFalse((boolean)alg.next());
    }

    @Test
    public void next_2_3() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(1);
        list.add(2);
        list.add(3);
        Combinations alg = new Combinations(list, 2);
        Assert.assertEquals((long)1L, (long)((Integer)alg.get(0)).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)alg.get(1)).intValue());
        Assert.assertTrue((boolean)alg.next());
        Assert.assertEquals((long)1L, (long)((Integer)alg.get(0)).intValue());
        Assert.assertEquals((long)3L, (long)((Integer)alg.get(1)).intValue());
        Assert.assertTrue((boolean)alg.next());
        Assert.assertEquals((long)2L, (long)((Integer)alg.get(0)).intValue());
        Assert.assertEquals((long)3L, (long)((Integer)alg.get(1)).intValue());
        Assert.assertFalse((boolean)alg.next());
    }

    @Test
    public void previous() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(1);
        list.add(2);
        list.add(3);
        Combinations alg = new Combinations(list, 2);
        Assert.assertTrue((boolean)alg.next());
        Assert.assertEquals((long)1L, (long)((Integer)alg.get(0)).intValue());
        Assert.assertEquals((long)3L, (long)((Integer)alg.get(1)).intValue());
        Assert.assertTrue((boolean)alg.previous());
        Assert.assertEquals((long)1L, (long)((Integer)alg.get(0)).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)alg.get(1)).intValue());
        Assert.assertFalse((boolean)alg.previous());
        Assert.assertTrue((boolean)alg.next());
        Assert.assertTrue((boolean)alg.next());
        Assert.assertEquals((long)2L, (long)((Integer)alg.get(0)).intValue());
        Assert.assertEquals((long)3L, (long)((Integer)alg.get(1)).intValue());
        Assert.assertFalse((boolean)alg.next());
        Assert.assertTrue((boolean)alg.previous());
        Assert.assertEquals((long)1L, (long)((Integer)alg.get(0)).intValue());
        Assert.assertEquals((long)3L, (long)((Integer)alg.get(1)).intValue());
    }

    @Test
    public void getList_getOutside() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(1);
        list.add(2);
        list.add(3);
        Combinations alg = new Combinations(list, 2);
        Assert.assertTrue((boolean)alg.next());
        ArrayList a = new ArrayList();
        alg.getBucket(a);
        List b = alg.getBucket(null);
        Assert.assertEquals((long)2L, (long)a.size());
        Assert.assertEquals((long)2L, (long)b.size());
        Assert.assertEquals((long)1L, (long)((Integer)a.get(0)).intValue());
        Assert.assertEquals((long)3L, (long)((Integer)a.get(1)).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)b.get(0)).intValue());
        Assert.assertEquals((long)3L, (long)((Integer)b.get(1)).intValue());
        a = new ArrayList();
        alg.getOutside(a);
        b = alg.getOutside(null);
        Assert.assertEquals((long)1L, (long)a.size());
        Assert.assertEquals((long)1L, (long)b.size());
        Assert.assertEquals((long)2L, (long)((Integer)a.get(0)).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)b.get(0)).intValue());
    }

    @Test
    public void computeNumShuffles() {
        Assert.assertEquals((long)2L, (long)this.computeNumShuffles(1, 2));
        Assert.assertEquals((long)1L, (long)this.computeNumShuffles(2, 2));
        Assert.assertEquals((long)3L, (long)this.computeNumShuffles(2, 3));
        Assert.assertEquals((long)20L, (long)this.computeNumShuffles(3, 6));
    }

    private long computeNumShuffles(int numBins, int numItems) {
        ArrayList<Integer> l = new ArrayList<Integer>();
        for (int i = 0; i < numItems; ++i) {
            l.add(i);
        }
        Combinations c = new Combinations(l, numBins);
        return c.computeTotalCombinations();
    }
}

