/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.clustering.kmeans;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import org.ddogleg.clustering.kmeans.AssignKMeans_F64;
import org.junit.Assert;
import org.junit.Test;

public class TestAssignKMeans_F64 {
    @Test
    public void serialize() {
        ArrayList<double[]> clusters = new ArrayList<double[]>();
        clusters.add(new double[]{10.0, 0.0, 0.0});
        clusters.add(new double[]{0.0, 0.0, 10.0});
        AssignKMeans_F64 alg = new AssignKMeans_F64(clusters);
        byte[] encoded = TestAssignKMeans_F64.save(alg);
    }

    public static byte[] save(Object o) {
        try {
            FileOutputStream fileOut = new FileOutputStream("junk.txt");
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(fileOut);
            out.writeObject(o);
            out.close();
            return byteStream.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T load(byte[] data) {
        try {
            ByteArrayInputStream fileIn = new ByteArrayInputStream(data);
            ObjectInputStream in = new ObjectInputStream(fileIn);
            Object obj = in.readObject();
            in.close();
            return (T)obj;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void assign() {
        ArrayList<double[]> clusters = new ArrayList<double[]>();
        clusters.add(new double[]{10.0, 0.0, 0.0});
        clusters.add(new double[]{0.0, 0.0, 10.0});
        AssignKMeans_F64 alg = new AssignKMeans_F64(clusters);
        Assert.assertEquals((long)1L, (long)alg.assign(new double[]{0.0, 0.0, 9.0}));
        Assert.assertEquals((long)0L, (long)alg.assign(new double[]{12.0, 0.0, 0.0}));
    }

    @Test
    public void assign_soft() {
        ArrayList<double[]> clusters = new ArrayList<double[]>();
        clusters.add(new double[]{10.0, 0.0, 0.0});
        clusters.add(new double[]{5.0, 0.0, 0.0});
        AssignKMeans_F64 alg = new AssignKMeans_F64(clusters);
        double[] histogram = new double[2];
        alg.assign(new double[]{10.0, 0.0, 0.0}, histogram);
        Assert.assertEquals((double)1.0, (double)histogram[0], (double)1.0E-8);
        Assert.assertEquals((double)0.0, (double)histogram[1], (double)1.0E-8);
        alg.assign(new double[]{6.0, 0.0, 0.0}, histogram);
        Assert.assertTrue((histogram[0] * 10.0 < histogram[1] ? 1 : 0) != 0);
        clusters.add(new double[]{5000.0, 0.0, 0.0});
        histogram = new double[3];
        alg.assign(new double[]{6.0, 0.0, 0.0}, histogram);
        Assert.assertTrue((histogram[0] / 30.0 > histogram[2] ? 1 : 0) != 0);
        Assert.assertEquals((double)histogram[0], (double)histogram[1], (double)0.01);
    }

    @Test
    public void copy() {
        ArrayList<double[]> clusters = new ArrayList<double[]>();
        clusters.add(new double[]{10.0, 0.0, 0.0});
        clusters.add(new double[]{0.0, 0.0, 10.0});
        AssignKMeans_F64 original = new AssignKMeans_F64(clusters);
        AssignKMeans_F64 copy = (AssignKMeans_F64)original.copy();
        Assert.assertEquals((long)original.clusters.size(), (long)copy.clusters.size());
        for (int i = 0; i < original.clusters.size(); ++i) {
            double[] c;
            double[] o = original.clusters.get(i);
            Assert.assertTrue((o != (c = copy.clusters.get(i)) ? 1 : 0) != 0);
            for (int j = 0; j < o.length; ++j) {
                Assert.assertEquals((double)o[j], (double)c[j], (double)1.0E-8);
            }
        }
    }
}

