/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.clustering.kmeans;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.ddogleg.clustering.kmeans.InitializeKMeans_F64;
import org.ddogleg.struct.GrowQueue_B;

public class InitializeStandard_F64
implements InitializeKMeans_F64 {
    Random rand;
    GrowQueue_B marked = new GrowQueue_B();
    List<double[]> unused = new ArrayList<double[]>();

    @Override
    public void init(int pointDimension, long randomSeed) {
        this.rand = new Random(randomSeed);
    }

    @Override
    public void selectSeeds(List<double[]> points, List<double[]> seeds) {
        if (seeds.size() > points.size()) {
            throw new IllegalArgumentException("More seeds requested than points!");
        }
        if (seeds.size() * 2 > points.size()) {
            this.unused.addAll(points);
            for (int i = 0; i < seeds.size(); ++i) {
                double[] s = seeds.get(i);
                double[] p = this.unused.remove(this.rand.nextInt(this.unused.size()));
                System.arraycopy(p, 0, s, 0, s.length);
            }
            this.unused.clear();
        } else {
            this.marked.resize(points.size());
            this.marked.fill(false);
            int numSelected = 0;
            while (numSelected < seeds.size()) {
                int drawn = this.rand.nextInt(points.size());
                if (this.marked.get(drawn)) continue;
                this.marked.set(drawn, true);
                double[] s = seeds.get(numSelected);
                double[] p = points.get(drawn);
                System.arraycopy(p, 0, s, 0, s.length);
                ++numSelected;
            }
        }
    }
}

