/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.clustering.gmm;

import org.ddogleg.clustering.gmm.GaussianGmm_F64;
import org.ddogleg.clustering.gmm.GaussianLikelihoodManager;
import org.ddogleg.struct.FastQueue;
import org.ejml.data.DenseMatrix64F;
import org.ejml.equation.Equation;
import org.junit.Assert;
import org.junit.Test;

public class TestGaussianLikelihoodManager {
    @Test
    public void likelihood() {
        int DOF = 3;
        GaussianGmm_F64 a = new GaussianGmm_F64(DOF);
        GaussianGmm_F64 b = new GaussianGmm_F64(DOF);
        a.mean.data = new double[]{5.0, 3.0, 5.0};
        b.mean.data = new double[]{-5.0, 6.0, -1.5};
        a.covariance.set(0, 0, 3.0);
        a.covariance.set(1, 1, 6.0);
        a.covariance.set(2, 2, 12.0);
        b.covariance.set(0, 0, 20.0);
        b.covariance.set(1, 1, 30.0);
        b.covariance.set(2, 2, 25.0);
        FastQueue<GaussianGmm_F64> mixtures = new FastQueue<GaussianGmm_F64>(GaussianGmm_F64.class, false);
        mixtures.add(a);
        mixtures.add(b);
        GaussianLikelihoodManager manager = new GaussianLikelihoodManager(DOF, mixtures.toList());
        manager.precomputeAll();
        double[] p = new double[]{4.0, 3.0, -1.0};
        double foundA = manager.getLikelihood(0).likelihood(p);
        double chiSqA = manager.getLikelihood(0).getChisq();
        double foundB = manager.getLikelihood(1).likelihood(p);
        double chiSqB = manager.getLikelihood(1).getChisq();
        Assert.assertEquals((double)5.0, (double)a.mean.get(0, 0), (double)1.0E-8);
        Assert.assertEquals((double)3.0, (double)a.covariance.get(0, 0), (double)1.0E-8);
        double expectedA = TestGaussianLikelihoodManager.computeLikelihood(a, p);
        double expectedB = TestGaussianLikelihoodManager.computeLikelihood(b, p);
        Assert.assertEquals((double)this.computeChiSq(a, p), (double)chiSqA, (double)1.0E-8);
        Assert.assertEquals((double)this.computeChiSq(b, p), (double)chiSqB, (double)1.0E-8);
        double found = foundA / foundB;
        double expected = expectedA / expectedB;
        Assert.assertEquals((double)found, (double)expected, (double)1.0E-8);
    }

    public static double computeLikelihood(GaussianGmm_F64 g, double[] p) {
        Equation eq = new Equation();
        eq.alias(g.mean, "mu", g.covariance, "S", p.length, "D");
        eq.alias(DenseMatrix64F.wrap(p.length, 1, p), "x");
        eq.process("left = 1.0/((2*pi)^(D/2.0)*sqrt(det(S)))");
        eq.process("likelihood = left*exp(-0.5*(x-mu)'*inv(S)*(x-mu))");
        return eq.lookupDouble("likelihood");
    }

    private double computeChiSq(GaussianGmm_F64 g, double[] p) {
        Equation eq = new Equation();
        eq.alias(g.mean, "mu", g.covariance, "S");
        eq.alias(DenseMatrix64F.wrap(p.length, 1, p), "x");
        eq.process("chisq = (x-mu)'*inv(S)*(x-mu)");
        return eq.lookupDouble("chisq");
    }
}

