/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.clustering;

import java.util.ArrayList;
import java.util.List;
import org.ddogleg.clustering.AssignCluster;
import org.ddogleg.clustering.ComputeClusters;
import org.ddogleg.clustering.kmeans.TestStandardKMeans_F64;
import org.junit.Assert;
import org.junit.Test;

public abstract class GenericClusterChecks_F64 {
    public abstract ComputeClusters<double[]> createClustersAlg(boolean var1);

    @Test
    public void simpleCluster() {
        ArrayList<double[]> points = new ArrayList<double[]>();
        for (int i = 0; i < 20; ++i) {
            points.add(new double[]{i});
            points.add(new double[]{100 + i});
            points.add(new double[]{200 + i});
        }
        ComputeClusters<double[]> alg = this.createClustersAlg(true);
        alg.init(1, 243234L);
        alg.process(points, 3);
        AssignCluster<double[]> ass = alg.getAssignment();
        int cluster0 = ass.assign((double[])points.get(0));
        int cluster1 = ass.assign((double[])points.get(1));
        int cluster2 = ass.assign((double[])points.get(2));
        Assert.assertTrue((cluster0 != cluster1 ? 1 : 0) != 0);
        Assert.assertTrue((cluster0 != cluster2 ? 1 : 0) != 0);
        Assert.assertTrue((cluster1 != cluster2 ? 1 : 0) != 0);
        int index = 0;
        for (int i = 0; i < 20; ++i) {
            Assert.assertEquals((double)cluster0, (double)ass.assign((double[])points.get(index++)), (double)1.0E-8);
            Assert.assertEquals((double)cluster1, (double)ass.assign((double[])points.get(index++)), (double)1.0E-8);
            Assert.assertEquals((double)cluster2, (double)ass.assign((double[])points.get(index++)), (double)1.0E-8);
        }
    }

    @Test
    public void computeDistance() {
        int DOF = 5;
        List<double[]> points = TestStandardKMeans_F64.createPoints(DOF, 200, true);
        ComputeClusters<double[]> alg = this.createClustersAlg(false);
        alg.init(DOF, 243234L);
        alg.process(points, 3);
        double first = alg.getDistanceMeasure();
        alg.process(points, 10);
        double second = alg.getDistanceMeasure();
        Assert.assertTrue((first != second ? 1 : 0) != 0);
        Assert.assertFalse((boolean)Double.isNaN(first));
        Assert.assertFalse((boolean)Double.isNaN(second));
        Assert.assertFalse((boolean)Double.isInfinite(first));
        Assert.assertFalse((boolean)Double.isInfinite(second));
    }
}

