/*
 * Decompiled with CFR 0.152.
 */
package com.mhuss.AstroLib;

import com.mhuss.AstroLib.ValueException;
import com.mhuss.AstroLib.VisLimitAngularBrightnessData;
import com.mhuss.AstroLib.VisLimitFixedBrightnessData;
import java.text.DecimalFormat;

public class VisLimit {
    public static final int BAND_0 = 1;
    public static final int BAND_1 = 2;
    public static final int BAND_2 = 4;
    public static final int BAND_3 = 8;
    public static final int BAND_4 = 16;
    private static final int BANDS = 5;
    private static final double LOG_10 = 2.302585093;
    private VisLimitFixedBrightnessData fixed;
    private VisLimitAngularBrightnessData angular;
    private int mask;
    static final double[] fourthPowerTerms = new double[]{5.155601, 2.441406, 1.0, 0.381117, 0.13947};
    static final double[] onePointThreePowerTerms = new double[]{1.704083, 1.336543, 1.0, 0.730877, 0.527177};
    static final double[] oz = new double[]{0.0, 0.0, 0.031, 0.008, 0.0};
    static final double[] wt = new double[]{0.074, 0.045, 0.031, 0.02, 0.015};
    static final double[] bo = new double[]{8.0E-14, 7.0E-14, 1.0E-13, 1.0E-13, 3.0E-13};
    static final double[] cm = new double[]{1.36, 0.91, 0.0, -0.76, -1.17};
    static final double[] ms = new double[]{-25.96, -26.09, -26.74, -27.26, -27.55};
    static final double[] mo = new double[]{-10.93, -10.45, -11.05, -11.9, -12.7};
    private double airMassSun;
    private double airMassMoon;
    private double lunarMag;
    private double[] k = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
    private double[] c3 = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
    private double[] c4 = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
    private double[] ka = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
    private double[] kr = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
    private double[] ko = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
    private double[] kw = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
    private double yearTerm;
    private double airMassGas;
    private double airMassAerosol;
    private double airMassOzone;
    private double[] extinction = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
    private double[] brightness = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};

    public VisLimit() {
        this.fixed = new VisLimitFixedBrightnessData();
        this.angular = new VisLimitAngularBrightnessData();
    }

    public VisLimit(int bandMask, VisLimitFixedBrightnessData fbd, VisLimitAngularBrightnessData abd) {
        this.mask = bandMask;
        this.setBrightnessParams(fbd);
        this.computeSkyBrightness(abd);
        this.computeExtinction();
    }

    public void setBrightnessParams(VisLimitFixedBrightnessData fbd) {
        this.fixed = fbd;
        double monthAngle = (this.fixed.month - 3.0) * Math.PI / 6.0;
        double krCoeff = 0.1066 * Math.exp(-this.fixed.htAboveSeaInMeters / 8200.0);
        double kaCoeff = 0.1 * Math.exp(-this.fixed.htAboveSeaInMeters / 1500.0);
        if (this.fixed.relativeHumidity > 0.0) {
            double humidityParam = this.fixed.relativeHumidity >= 100.0 ? 1000000.0 : 1.0 - 0.32 / Math.log(this.fixed.relativeHumidity / 100.0);
            kaCoeff *= Math.exp(1.33 * Math.log(humidityParam));
        }
        kaCoeff = this.fixed.latitude < 0.0 ? (kaCoeff *= 1.0 - Math.sin(monthAngle)) : (kaCoeff *= 1.0 + Math.sin(monthAngle));
        double koCoeff = (3.0 + 0.4 * (this.fixed.latitude * Math.cos(monthAngle) - Math.cos(3.0 * this.fixed.latitude))) / 3.0;
        double kwCoeff = 0.94 * (this.fixed.relativeHumidity / 100.0) * Math.exp(this.fixed.temperatureInC / 15.0) * Math.exp(-this.fixed.htAboveSeaInMeters / 8200.0);
        this.yearTerm = 1.0 + 0.3 * Math.cos(Math.PI * 2 * (this.fixed.year - 1992.0) / 11.0);
        this.airMassMoon = VisLimit.computeAirMass(this.fixed.zenithAngMoon);
        this.airMassSun = VisLimit.computeAirMass(this.fixed.zenithAngSun);
        double moonElong = this.fixed.moonElongation * 180.0 / Math.PI;
        this.lunarMag = -12.73 + moonElong * (0.026 + 4.0E-9 * (moonElong * moonElong * moonElong));
        for (int i = 0; i < 5; ++i) {
            this.kr[i] = krCoeff * fourthPowerTerms[i];
            this.ka[i] = kaCoeff * onePointThreePowerTerms[i];
            this.ko[i] = koCoeff * oz[i];
            this.kw[i] = kwCoeff * wt[i];
            this.k[i] = this.kr[i] + this.ka[i] + this.ko[i] + this.kw[i];
            this.c3[i] = VisLimit.magToBrightness(this.k[i] * this.airMassMoon);
            this.c4[i] = VisLimit.magToBrightness(this.k[i] * this.airMassSun);
        }
    }

    public void computeSkyBrightness(VisLimitAngularBrightnessData abd) {
        this.angular = abd;
        double airMass = VisLimit.computeAirMass(this.angular.zenithAngle);
        double sinZenith = Math.sin(this.angular.zenithAngle);
        double brightnessDrop2150 = 0.4 + 0.6 / Math.sqrt(1.0 - 0.96 * sinZenith * sinZenith);
        double fm = VisLimit.computeFFactor(this.angular.distMoon);
        double fs = VisLimit.computeFFactor(this.angular.distSun);
        for (int i = 0; i < 5; ++i) {
            double brightnessMoon;
            if (0 == (this.mask >> i & 1)) continue;
            double bn = bo[i] * this.yearTerm;
            double directLoss = VisLimit.magToBrightness(this.k[i] * airMass);
            bn *= brightnessDrop2150;
            bn *= directLoss;
            if (this.fixed.zenithAngMoon < 1.5707963267948966) {
                brightnessMoon = VisLimit.magToBrightness(this.lunarMag + cm[i] - mo[i] + 43.27);
                brightnessMoon *= 1.0 - directLoss;
                brightnessMoon *= fm * this.c3[i] + 440000.0 * (1.0 - this.c3[i]);
            } else {
                brightnessMoon = 0.0;
            }
            double twilightBrightness = ms[i] - mo[i] + 32.5 - (90.0 - this.fixed.zenithAngSun * 180.0 / Math.PI) - this.angular.zenithAngle / (Math.PI * 2 * this.k[i]);
            twilightBrightness = VisLimit.magToBrightness(twilightBrightness);
            twilightBrightness *= 100.0 / (this.angular.distSun * 180.0 / Math.PI);
            double brightnessDaylight = VisLimit.magToBrightness(ms[i] - mo[i] + 43.27);
            brightnessDaylight *= 1.0 - directLoss;
            this.brightness[i] = brightnessDaylight > twilightBrightness ? bn + (twilightBrightness *= 1.0 - VisLimit.magToBrightness(this.k[i])) + brightnessMoon : bn + (brightnessDaylight *= fs * this.c4[i] + 440000.0 * (1.0 - this.c4[i])) + brightnessMoon;
        }
    }

    public double limitingMagnitude() {
        double c2;
        double c1;
        double bl = this.brightness[2] / 1.11E-15;
        if (bl > 1500.0) {
            c1 = 4.4668E-9;
            c2 = 1.2589E-6;
        } else {
            c1 = 1.5849E-10;
            c2 = 0.012589;
        }
        double tval = 1.0 + Math.sqrt(c2 * bl);
        double th = c1 * tval * tval;
        return -16.57 + VisLimit.brightnessToMag(th) - this.extinction[2];
    }

    void computeExtinction() {
        double cosZenithAng = Math.cos(this.angular.zenithAngle);
        this.airMassGas = 1.0 / (cosZenithAng + 0.0286 * Math.exp(-10.5 * cosZenithAng));
        this.airMassAerosol = 1.0 / (cosZenithAng + 0.0123 * Math.exp(-24.5 * cosZenithAng));
        double tval = Math.sin(this.angular.zenithAngle) / 1.0031357792411415;
        this.airMassOzone = 1.0 / Math.sqrt(1.0 - tval * tval);
        for (int i = 0; i < 5; ++i) {
            if (0 == (this.mask >> i & 1)) continue;
            this.extinction[i] = (this.kr[i] + this.kw[i]) * this.airMassGas + this.ka[i] * this.airMassAerosol + this.ko[i] * this.airMassOzone;
        }
    }

    public void setMask(int m) {
        this.mask = m;
    }

    public double getK(int i) throws ValueException {
        if (i < 0 || i > 5) {
            throw new ValueException("invalid band data index.");
        }
        return this.k[i];
    }

    public double getBrightness(int i) throws ValueException {
        if (i < 0 || i > 5) {
            throw new ValueException("invalid band data index.");
        }
        return this.brightness[i];
    }

    public double getExtinction(int i) throws ValueException {
        if (i < 0 || i > 5) {
            throw new ValueException("invalid band data index.");
        }
        return this.extinction[i];
    }

    private static double magToBrightness(double m) {
        return Math.exp(-0.4 * m * 2.302585093);
    }

    private static double brightnessToMag(double b) {
        return -2.5 * Math.log(b) / 2.302585093;
    }

    private static double computeAirMass(double zenithAngle) {
        double rval = 40.0;
        double cosAng = Math.cos(zenithAngle);
        if (cosAng > 0.0) {
            rval = 1.0 / (cosAng + 0.025 * Math.exp(-11.0 * cosAng));
        }
        return rval;
    }

    private static double computeFFactor(double objDist) {
        double objDistDegrees = objDist * 180.0 / Math.PI;
        double cosDist = Math.cos(objDist);
        double rval = 6.2E7 / (objDistDegrees * objDistDegrees) + Math.exp(2.302585093 * (6.15 - objDistDegrees / 40.0));
        return rval += 229086.0 * (1.06 + cosDist * cosDist);
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("usage: VisLimit <zenith angle>\n");
            return;
        }
        double zenithAngle = Double.parseDouble(args[0]);
        VisLimitFixedBrightnessData f = new VisLimitFixedBrightnessData(Math.toRadians(40.0), Math.toRadians(100.0), Math.toRadians(180.0), 1000.0, Math.toRadians(40.0), 15.0, 40.0, 2001.0, 2.0);
        VisLimitAngularBrightnessData a = new VisLimitAngularBrightnessData(Math.toRadians(zenithAngle), Math.toRadians(50.0), Math.toRadians(40.0));
        int bandMask = 31;
        VisLimit v = new VisLimit(bandMask, f, a);
        DecimalFormat nf = new DecimalFormat("##0.00");
        try {
            for (int i = 0; i < 5; ++i) {
                System.out.println("k: " + nf.format(v.getK(i)) + ", br: " + nf.format(v.getBrightness(i)) + ", ex: " + nf.format(v.getExtinction(i)));
            }
        }
        catch (ValueException ve) {
            // empty catch block
        }
        System.out.println("Limiting magnitude: " + nf.format(v.limitingMagnitude()));
    }
}

