/*
 * Decompiled with CFR 0.152.
 */
package com.mhuss.AstroLib;

public class Pluto2 {
    static double cJD = 0.0;
    static double cL = 0.0;
    static double cB = 0.0;
    static double cR = 0.0;
    static final int PLUTO_COEFFS = 43;
    static final int[][] argument = new int[][]{{0, 0, 1}, {0, 0, 2}, {0, 0, 3}, {0, 0, 4}, {0, 0, 5}, {0, 0, 6}, {0, 1, -1}, {0, 1, 0}, {0, 1, 1}, {0, 1, 2}, {0, 1, 3}, {0, 2, -2}, {0, 2, -1}, {0, 2, 0}, {1, -1, 0}, {1, -1, 1}, {1, 0, -3}, {1, 0, -2}, {1, 0, -1}, {1, 0, 0}, {1, 0, 1}, {1, 0, 2}, {1, 0, 3}, {1, 0, 4}, {1, 1, -3}, {1, 1, -2}, {1, 1, -1}, {1, 1, 0}, {1, 1, 1}, {1, 1, 3}, {2, 0, -6}, {2, 0, -5}, {2, 0, -4}, {2, 0, -3}, {2, 0, -2}, {2, 0, -1}, {2, 0, 0}, {2, 0, 1}, {2, 0, 2}, {2, 0, 3}, {3, 0, -2}, {3, 0, -1}, {3, 0, 0}};
    static final long[][] longitude = new long[][]{{-19799805L, 19850055L}, {897144L, -4954829L}, {611149L, 1211027L}, {-341243L, -189585L}, {129287L, -34992L}, {-38164L, 30893L}, {20442L, -9987L}, {-4063L, -5071L}, {-6016L, -3336L}, {-3956L, 3039L}, {-667L, 3572L}, {1276L, 501L}, {1152L, -917L}, {630L, -1277L}, {2571L, -459L}, {899L, -1449L}, {-1016L, 1043L}, {-2343L, -1012L}, {7042L, 788L}, {1199L, -338L}, {418L, -67L}, {120L, -274L}, {-60L, -159L}, {-82L, -29L}, {-36L, -20L}, {-40L, 7L}, {-14L, 22L}, {4L, 13L}, {5L, 2L}, {-1L, 0L}, {2L, 0L}, {-4L, 5L}, {4L, -7L}, {14L, 24L}, {-49L, -34L}, {163L, -48L}, {9L, 24L}, {-4L, 1L}, {-3L, 1L}, {1L, 3L}, {-3L, -1L}, {5L, -3L}, {0L, 0L}};
    static final long[][] latitude = new long[][]{{-5452852L, -14974862L}, {3527812L, 1672790L}, {-1050748L, 327647L}, {178690L, -292153L}, {18650L, 100340L}, {-30697L, -25823L}, {4878L, 11248L}, {226L, -64L}, {2030L, -836L}, {69L, -604L}, {-247L, -567L}, {-57L, 1L}, {-122L, 175L}, {-49L, -164L}, {-197L, 199L}, {-25L, 217L}, {589L, -248L}, {-269L, 711L}, {185L, 193L}, {315L, 807L}, {-130L, -43L}, {5L, 3L}, {2L, 17L}, {2L, 5L}, {2L, 3L}, {3L, 1L}, {2L, -1L}, {1L, -1L}, {0L, -1L}, {0L, 0L}, {0L, -2L}, {2L, 2L}, {-7L, 0L}, {10L, -8L}, {-3L, 20L}, {6L, 5L}, {14L, 17L}, {-2L, 0L}, {0L, 0L}, {0L, 0L}, {0L, 1L}, {0L, 0L}, {1L, 0L}};
    static final long[][] radius = new long[][]{{66865439L, 68951812L}, {-11827535L, -332538L}, {1593179L, -1438890L}, {-18444L, 483220L}, {-65977L, -85431L}, {31174L, -6032L}, {-5794L, 22161L}, {4601L, 4032L}, {-1729L, 234L}, {-415L, 702L}, {239L, 723L}, {67L, -67L}, {1034L, -451L}, {-129L, 504L}, {480L, -231L}, {2L, -441L}, {-3359L, 265L}, {7856L, -7832L}, {36L, 45763L}, {8663L, 8547L}, {-809L, -769L}, {263L, -144L}, {-126L, 32L}, {-35L, -16L}, {-19L, -4L}, {-15L, 8L}, {-4L, 12L}, {5L, 6L}, {3L, 1L}, {6L, -2L}, {2L, 2L}, {-2L, -2L}, {14L, 13L}, {-63L, 13L}, {136L, -236L}, {273L, 1065L}, {251L, 149L}, {-25L, -9L}, {9L, -2L}, {-8L, 7L}, {2L, -10L}, {19L, 35L}, {10L, 2L}};

    static void ln_get_pluto_helio_coords(double JD, double[] lbr) {
        double sum_longitude = 0.0;
        double sum_latitude = 0.0;
        double sum_radius = 0.0;
        double t = (JD - 2451545.0) / 36525.0;
        double J = 34.35 + 3034.9057 * t;
        double S = 50.08 + 1222.1138 * t;
        double P = 238.96 + 144.96 * t;
        for (int i = 0; i < 43; ++i) {
            double a = (double)argument[i][0] * J + (double)argument[i][1] * S + (double)argument[i][2] * P;
            double sin_a = Math.sin(Math.toRadians(a));
            double cos_a = Math.cos(Math.toRadians(a));
            sum_longitude += (double)longitude[i][0] * sin_a + (double)longitude[i][1] * cos_a;
            sum_latitude += (double)latitude[i][0] * sin_a + (double)latitude[i][1] * cos_a;
            sum_radius += (double)radius[i][0] * sin_a + (double)radius[i][1] * cos_a;
        }
        lbr[0] = Math.toRadians(238.958116 + 144.96 * t + sum_longitude * 1.0E-6);
        lbr[1] = Math.toRadians(-3.908239 + sum_latitude * 1.0E-6);
        lbr[2] = 40.7241346 + sum_radius * 1.0E-7;
    }

    class pluto_radius {
        double A;
        double B;

        pluto_radius() {
        }
    }

    class pluto_latitude {
        double A;
        double B;

        pluto_latitude() {
        }
    }

    class pluto_longitude {
        double A;
        double B;

        pluto_longitude() {
        }
    }

    class pluto_argument {
        double J;
        double S;
        double P;

        pluto_argument() {
        }
    }
}

