/*
 * Decompiled with CFR 0.152.
 */
package functionplotter.xml;

import functionplotter.exception.AppException;
import functionplotter.exception.ExceptionUtilities;
import java.io.File;
import java.net.URL;

public class XmlValidationException
extends AppException {
    private static final int MAX_PATHNAME_LENGTH = 160;
    private static final String FIRST_ERROR_STR = "First error (of ";
    private File file;
    private URL url;
    private String[] errorStrings;

    public XmlValidationException(AppException.Id id, File file) {
        super(id);
        this.file = file;
    }

    public XmlValidationException(AppException.Id id, File file, String[] stringArray) {
        this(id, file);
        this.errorStrings = stringArray;
    }

    public XmlValidationException(AppException.Id id, URL uRL) {
        super(id);
        this.url = uRL;
    }

    public XmlValidationException(AppException.Id id, URL uRL, String[] stringArray) {
        this(id, uRL);
        this.errorStrings = stringArray;
    }

    protected static String getPathname(File file) {
        return ExceptionUtilities.getLimitedPathname(file, 160);
    }

    @Override
    public String getPrefix() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.file != null) {
            stringBuilder.append(XmlValidationException.getPathname(this.file));
            stringBuilder.append('\n');
        } else if (this.url != null) {
            stringBuilder.append(this.url);
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    @Override
    public String getSuffix() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.errorStrings != null && this.errorStrings.length > 0) {
            stringBuilder.append('\n');
            if (this.errorStrings.length > 1) {
                stringBuilder.append(FIRST_ERROR_STR);
                stringBuilder.append(this.errorStrings.length);
                stringBuilder.append("):\n");
            }
            stringBuilder.append(this.errorStrings[0]);
        }
        return stringBuilder.toString();
    }

    public String[] getErrorStrings() {
        return this.errorStrings;
    }
}

