/*
 * Decompiled with CFR 0.152.
 */
package functionplotter.xml;

import java.util.ArrayList;
import java.util.List;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public class ErrorLogger
implements ErrorHandler {
    private static final String ERROR_STR = "Error";
    private static final String FATAL_ERROR_STR = "Fatal error";
    private static final String WARNING_STR = "Warning";
    private static final String LINE_STR = "Line ";
    private List<String> errorStrings = new ArrayList<String>();

    @Override
    public void error(SAXParseException sAXParseException) {
        this.append(ERROR_STR, sAXParseException);
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) {
        this.append(FATAL_ERROR_STR, sAXParseException);
    }

    @Override
    public void warning(SAXParseException sAXParseException) {
        this.append(WARNING_STR, sAXParseException);
    }

    public boolean isEmpty() {
        return this.errorStrings.isEmpty();
    }

    public void clear() {
        this.errorStrings.clear();
    }

    public String[] getErrorStrings() {
        return this.errorStrings.toArray(new String[this.errorStrings.size()]);
    }

    private void append(String string, SAXParseException sAXParseException) {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append(LINE_STR);
        stringBuilder.append(sAXParseException.getLineNumber());
        stringBuilder.append(": [");
        stringBuilder.append(string);
        stringBuilder.append("] ");
        stringBuilder.append(sAXParseException.getMessage());
        this.errorStrings.add(stringBuilder.toString());
    }
}

