/*
 * Decompiled with CFR 0.152.
 */
package functionplotter.util;

import java.io.File;

public class PropertyString {
    public static final String KEY_PREFIX = "${";
    public static final String KEY_SUFFIX = "}";
    public static final String USER_HOME_PREFIX = "~";
    private static final int KEY_PREFIX_LENGTH = "${".length();
    private static final int KEY_SUFFIX_LENGTH = "}".length();
    private static final String ENV_PREFIX_KEY = "app.envPrefix";
    private static final String SYS_PREFIX_KEY = "app.sysPrefix";
    private static final String DEFAULT_ENV_PREFIX = "env.";
    private static final String DEFAULT_SYS_PREFIX = "sys.";
    private static final String DEFAULT_CONFIGURATION_NAME = "blankaspect";
    private static String envPrefix = "env.";
    private static String sysPrefix = "sys.";
    private static String configurationName = "blankaspect";

    private PropertyString() {
    }

    public static String getEnvPrefix() {
        try {
            String string = System.getProperty(ENV_PREFIX_KEY);
            if (string != null) {
                envPrefix = string + ".";
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return envPrefix;
    }

    public static String getSysPrefix() {
        try {
            String string = System.getProperty(SYS_PREFIX_KEY);
            if (string != null) {
                sysPrefix = string + ".";
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return sysPrefix;
    }

    public static String getConfigurationName() {
        String[] stringArray;
        Package package_ = PropertyString.class.getPackage();
        if (package_ != null && (stringArray = package_.getName().split(".")).length > 1) {
            configurationName = stringArray[1];
        }
        return configurationName;
    }

    public static String parse(String string) {
        if (string == null) {
            return null;
        }
        PropertyString.getEnvPrefix();
        PropertyString.getSysPrefix();
        StringBuilder stringBuilder = new StringBuilder(string);
        int n = 0;
        while (n < stringBuilder.length() && (n = stringBuilder.indexOf(KEY_PREFIX, n)) >= 0) {
            int n2 = n += KEY_PREFIX_LENGTH;
            if ((n = stringBuilder.indexOf(KEY_SUFFIX, n)) < 0) {
                n = n2;
                continue;
            }
            String string2 = new String();
            if (n > n2) {
                String string3 = stringBuilder.substring(n2, n);
                try {
                    String string4;
                    if (string3.startsWith(envPrefix)) {
                        string4 = System.getenv(string3.substring(envPrefix.length()));
                        if (string4 != null) {
                            string2 = string4;
                        }
                    } else if (string3.startsWith(sysPrefix)) {
                        string4 = System.getProperty(string3.substring(sysPrefix.length()));
                        if (string4 != null) {
                            string2 = string4;
                        }
                    } else {
                        string4 = System.getProperty(string3);
                        if (string4 == null) {
                            string4 = System.getenv(string3);
                        }
                        if (string4 != null) {
                            string2 = string4;
                        }
                    }
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            stringBuilder.replace(n2 - KEY_PREFIX_LENGTH, n + KEY_SUFFIX_LENGTH, string2);
            n = n2 - KEY_PREFIX_LENGTH + string2.length();
        }
        return stringBuilder.toString();
    }

    public static String parsePathname(String string) {
        if (string.startsWith(USER_HOME_PREFIX)) {
            int n = USER_HOME_PREFIX.length();
            if (string.length() == n || string.charAt(n) == File.separatorChar || string.charAt(n) == '/') {
                try {
                    String string2 = System.getProperty("user.home");
                    if (string2 != null) {
                        string = string2 + string.substring(n);
                    }
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        }
        return PropertyString.parse(string);
    }
}

