/*
 * Decompiled with CFR 0.152.
 */
package functionplotter.util;

import functionplotter.exception.AppException;
import functionplotter.exception.FileException;
import functionplotter.exception.UrlException;
import functionplotter.util.Property;
import functionplotter.util.StringKVPair;
import functionplotter.xml.XmlFile;
import functionplotter.xml.XmlUtilities;
import functionplotter.xml.XmlWriter;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PropertySet
implements Property.Source,
Property.Target,
XmlFile.ElementWriter {
    private static final String PROPERTY_SET_STR = "Property set";
    private static final String FILE_STR = "file";
    private static final int INDENT_INCREMENT = 2;
    protected Hashtable<String, String> properties = new Hashtable();
    protected Document document;

    public PropertySet() {
    }

    public PropertySet(String string) throws AppException {
        this();
        this.document = XmlUtilities.createDocumentBuilder(false).newDocument();
        this.document.appendChild(this.document.createElement(string));
    }

    public PropertySet(String string, String string2, String string3) throws AppException {
        this(string);
        if (string2 != null) {
            this.document.getDocumentElement().setAttribute("xmlns", string2);
        }
        this.document.getDocumentElement().setAttribute("version", string3);
    }

    @Override
    public String getSourceName() {
        return PROPERTY_SET_STR;
    }

    @Override
    public String getProperty(String string) {
        return this.get(string);
    }

    @Override
    public boolean putProperty(String string, String string2) {
        return this.put(string, string2);
    }

    @Override
    public void writeElement(XmlWriter xmlWriter, Element element, int n) throws IOException {
        if (element.getTagName().equals("property")) {
            xmlWriter.writeEmptyElement(element.getTagName(), XmlWriter.createAttributeList(element), n, false);
        } else {
            xmlWriter.writeElementStart(element.getTagName(), XmlWriter.createAttributeList(element), n, true, false);
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() == 1) {
                    this.writeElement(xmlWriter, (Element)node, n + 2);
                    continue;
                }
                if (node.getNodeType() != 3) continue;
                xmlWriter.write(node.getNodeValue());
            }
            xmlWriter.writeElementEnd(element.getTagName(), n);
        }
    }

    public String get(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        return this.properties.get(string);
    }

    public boolean put(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        boolean bl = false;
        if (string2 != null) {
            this.properties.put(string, string2);
            bl = true;
        }
        return bl;
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public List<StringKVPair> toList() {
        ArrayList<StringKVPair> arrayList = new ArrayList<StringKVPair>();
        for (String string : this.properties.keySet()) {
            arrayList.add(new StringKVPair(string, this.properties.get(string)));
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public String getVersionString() {
        return XmlUtilities.getAttribute(this.document.getDocumentElement(), "version");
    }

    public void read(File file, String string) throws AppException {
        try {
            this.document = XmlFile.read(file);
            if (!this.document.getDocumentElement().getTagName().equals(string)) {
                throw new FileException((AppException.Id)ErrorId.UNEXPECTED_FILE_FORMAT, file);
            }
            this.updateProperties();
        }
        catch (AppException appException) {
            appException.setSubstitutionString(this.getFileKindString());
            throw appException;
        }
    }

    public void read(URL uRL, String string) throws AppException {
        try {
            this.document = XmlFile.read(uRL);
            if (!this.document.getDocumentElement().getTagName().equals(string)) {
                throw new UrlException((AppException.Id)ErrorId.UNEXPECTED_FILE_FORMAT, uRL);
            }
            this.updateProperties();
        }
        catch (AppException appException) {
            appException.setSubstitutionString(this.getFileKindString());
            throw appException;
        }
    }

    public void write(File file) throws AppException {
        this.write(file, null);
    }

    public void write(File file, String string) throws AppException {
        if (this.document == null) {
            throw new IllegalStateException();
        }
        Element element = this.document.getDocumentElement();
        NodeList nodeList = element.getChildNodes();
        for (int i = nodeList.getLength() - 1; i >= 0; --i) {
            Node object = nodeList.item(i);
            if (object.getNodeType() == 2 && object.getNodeName().equals("version")) continue;
            element.removeChild(object);
        }
        if (string != null) {
            element.setAttribute("version", string);
        }
        for (StringKVPair stringKVPair : this.toList()) {
            Element element2 = this.document.createElement("property");
            element2.setAttribute("key", (String)stringKVPair.getKey());
            element2.setAttribute("value", (String)stringKVPair.getValue());
            element.appendChild(element2);
        }
        try {
            XmlFile.write(file, this.document, XmlWriter.Standalone.NO, this);
        }
        catch (AppException appException) {
            appException.setSubstitutionString(this.getFileKindString());
            throw appException;
        }
    }

    protected String getFileKindString() {
        return FILE_STR;
    }

    private void updateProperties() {
        this.properties.clear();
        NodeList nodeList = this.document.getDocumentElement().getElementsByTagName("property");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            this.properties.put(element.getAttribute("key"), element.getAttribute("value"));
        }
    }

    private static enum ErrorId implements AppException.Id
    {
        UNEXPECTED_FILE_FORMAT("The %1 does not have the expected format.");

        private String message;

        private ErrorId(String string2) {
            this.message = string2;
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }

    private static interface AttrName {
        public static final String KEY = "key";
        public static final String VALUE = "value";
        public static final String VERSION = "version";
        public static final String XMLNS = "xmlns";
    }

    private static interface ElementName {
        public static final String PROPERTY = "property";
    }
}

